/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum WebXml {
    INSTANCE;

    private static final Logger logger;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";
    private static final String XPATH_WELCOME_FILE = "welcome-file-list/welcome-file";
    private static final String XPATH_EXCEPTION_TYPE = "error-page/exception-type";
    private static final String XPATH_LOCATION = "location";
    private static final String XPATH_ERROR_PAGE_500_LOCATION = "error-page[error-code=500]/location";
    private static final String XPATH_ERROR_PAGE_DEFAULT_LOCATION = "error-page[not(error-code) and not(exception-type)]/location";
    private static final String XPATH_FORM_LOGIN_PAGE = "login-config[auth-method='FORM']/form-login-config/form-login-page";
    private static final String XPATH_SECURITY_CONSTRAINT = "security-constraint";
    private static final String XPATH_WEB_RESOURCE_URL_PATTERN = "web-resource-collection/url-pattern";
    private static final String XPATH_AUTH_CONSTRAINT = "auth-constraint";
    private static final String XPATH_AUTH_CONSTRAINT_ROLE_NAME = "auth-constraint/role-name";
    private static final String XPATH_SESSION_TIMEOUT = "session-config/session-timeout";
    private static final String ERROR_NOT_INITIALIZED = "WebXml is not initialized yet. Please use #init(ServletContext) method to manually initialize it.";
    private static final String ERROR_URL_MUST_START_WITH_SLASH = "URL must start with '/': '%s'";
    private static final String LOG_INITIALIZATION_ERROR = "WebXml failed to initialize. Perhaps your web.xml contains a typo?";
    private AtomicBoolean initialized = new AtomicBoolean();
    private List<String> welcomeFiles;
    private Map<Class<Throwable>, String> errorPageLocations;
    private String formLoginPage;
    private Map<String, Set<String>> securityConstraints;
    private int sessionTimeout;

    private void init() {
        if (!this.initialized.get() && Faces.getContext() != null) {
            this.init(Faces.getServletContext());
        }
    }

    public WebXml init(ServletContext servletContext) {
        if (servletContext != null && !this.initialized.getAndSet(true)) {
            try {
                Element webXml = WebXml.loadWebXml(servletContext).getDocumentElement();
                XPath xpath = XPathFactory.newInstance().newXPath();
                this.welcomeFiles = WebXml.parseWelcomeFiles(webXml, xpath);
                this.errorPageLocations = WebXml.parseErrorPageLocations(webXml, xpath);
                this.formLoginPage = WebXml.parseFormLoginPage(webXml, xpath);
                this.securityConstraints = WebXml.parseSecurityConstraints(webXml, xpath);
                this.sessionTimeout = WebXml.parseSessionTimeout(webXml, xpath);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, LOG_INITIALIZATION_ERROR, e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public String findErrorPageLocation(Throwable exception) {
        Map<Class<Throwable>, String> errorPageLocations = this.getErrorPageLocations();
        for (Map.Entry<Class<Throwable>, String> entry : errorPageLocations.entrySet()) {
            if (entry.getKey() != exception.getClass()) continue;
            return entry.getValue();
        }
        for (Map.Entry<Class<Throwable>, String> entry : errorPageLocations.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().isInstance(exception)) continue;
            return entry.getValue();
        }
        return errorPageLocations.get(null);
    }

    public boolean isAccessAllowed(String url, String role) {
        Map<String, Set<String>> securityConstraints = this.getSecurityConstraints();
        if (url.charAt(0) != '/') {
            throw new IllegalArgumentException(String.format(ERROR_URL_MUST_START_WITH_SLASH, url));
        }
        if (url.length() > 1 && url.charAt(url.length() - 1) == '/') {
            url = url.substring(0, url.length() - 1);
        }
        for (Map.Entry<String, Set<String>> entry : securityConstraints.entrySet()) {
            if (!WebXml.isExactMatch(entry.getKey(), url)) continue;
            return WebXml.isRoleMatch(entry.getValue(), role);
        }
        String path = url;
        String urlMatch = "";
        while (!path.isEmpty()) {
            Boolean roleMatch = null;
            for (Map.Entry<String, Set<String>> entry : securityConstraints.entrySet()) {
                if (urlMatch.length() >= entry.getKey().length() || !WebXml.isPrefixMatch(entry.getKey(), path)) continue;
                urlMatch = entry.getKey();
                roleMatch = WebXml.isRoleMatch(entry.getValue(), role);
            }
            if (roleMatch != null) {
                return roleMatch;
            }
            path = path.substring(0, path.lastIndexOf(47));
        }
        if (url.contains(".")) {
            for (Map.Entry<String, Set<String>> entry : securityConstraints.entrySet()) {
                if (!WebXml.isSuffixMatch(url, entry.getKey())) continue;
                return WebXml.isRoleMatch(entry.getValue(), role);
            }
        }
        return true;
    }

    private static boolean isExactMatch(String urlPattern, String url) {
        return url.equals(urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 2) : urlPattern);
    }

    private static boolean isPrefixMatch(String urlPattern, String url) {
        return urlPattern.endsWith("/*") ? url.startsWith(urlPattern.substring(0, urlPattern.length() - 2)) : false;
    }

    private static boolean isSuffixMatch(String urlPattern, String url) {
        return urlPattern.startsWith("*.") ? url.endsWith(urlPattern.substring(1)) : false;
    }

    private static boolean isRoleMatch(Set<String> roles, String role) {
        return roles == null || roles.contains(role) || role != null && roles.contains("*");
    }

    public List<String> getWelcomeFiles() {
        this.checkInitialized();
        return this.welcomeFiles;
    }

    public Map<Class<Throwable>, String> getErrorPageLocations() {
        this.checkInitialized();
        return this.errorPageLocations;
    }

    public String getFormLoginPage() {
        this.checkInitialized();
        return this.formLoginPage;
    }

    public Map<String, Set<String>> getSecurityConstraints() {
        this.checkInitialized();
        return this.securityConstraints;
    }

    public int getSessionTimeout() {
        this.checkInitialized();
        return this.sessionTimeout;
    }

    private void checkInitialized() {
        this.init();
        if (!this.initialized.get()) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
    }

    private static Document loadWebXml(ServletContext context) throws Exception {
        DocumentBuilder builder = WebXml.createDocumentBuilder();
        Document document = builder.newDocument();
        document.appendChild(document.createElement("web"));
        URL url = context.getResource(WEB_XML);
        if (url != null) {
            WebXml.parseAndAppendChildren(url, builder, document);
        }
        if (context.getMajorVersion() >= 3) {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(WEB_FRAGMENT_XML);
            while (urls.hasMoreElements()) {
                WebXml.parseAndAppendChildren(urls.nextElement(), builder, document);
            }
        }
        return document;
    }

    private static DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseAndAppendChildren(URL url, DocumentBuilder builder, Document document) throws Exception {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream input = null;
        try {
            input = connection.getInputStream();
            NodeList children = builder.parse(input).getDocumentElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                document.getDocumentElement().appendChild(document.importNode(children.item(i), true));
            }
        }
        finally {
            Utils.close(input);
        }
    }

    private static List<String> parseWelcomeFiles(Element webXml, XPath xpath) throws Exception {
        NodeList welcomeFileList = WebXml.getNodeList(webXml, xpath, XPATH_WELCOME_FILE);
        ArrayList<String> welcomeFiles = new ArrayList<String>(welcomeFileList.getLength());
        for (int i = 0; i < welcomeFileList.getLength(); ++i) {
            welcomeFiles.add(welcomeFileList.item(i).getTextContent().trim());
        }
        return Collections.unmodifiableList(welcomeFiles);
    }

    private static Map<Class<Throwable>, String> parseErrorPageLocations(Element webXml, XPath xpath) throws Exception {
        LinkedHashMap errorPageLocations = new LinkedHashMap();
        NodeList exceptionTypes = WebXml.getNodeList(webXml, xpath, XPATH_EXCEPTION_TYPE);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Class<?> key;
            Node node = exceptionTypes.item(i);
            Class<?> exceptionClass = Class.forName(node.getTextContent().trim());
            String exceptionLocation = xpath.compile(XPATH_LOCATION).evaluate(node.getParentNode()).trim();
            Class<?> clazz = key = exceptionClass == Throwable.class ? null : exceptionClass;
            if (errorPageLocations.containsKey(key)) continue;
            errorPageLocations.put(key, exceptionLocation);
        }
        if (!errorPageLocations.containsKey(null)) {
            String defaultLocation = xpath.compile(XPATH_ERROR_PAGE_500_LOCATION).evaluate(webXml).trim();
            if (Utils.isEmpty(defaultLocation)) {
                defaultLocation = xpath.compile(XPATH_ERROR_PAGE_DEFAULT_LOCATION).evaluate(webXml).trim();
            }
            if (!Utils.isEmpty(defaultLocation)) {
                errorPageLocations.put(null, defaultLocation);
            }
        }
        return Collections.unmodifiableMap(errorPageLocations);
    }

    private static String parseFormLoginPage(Element webXml, XPath xpath) throws Exception {
        String formLoginPage = xpath.compile(XPATH_FORM_LOGIN_PAGE).evaluate(webXml).trim();
        return Utils.isEmpty(formLoginPage) ? null : formLoginPage;
    }

    private static Map<String, Set<String>> parseSecurityConstraints(Element webXml, XPath xpath) throws Exception {
        LinkedHashMap securityConstraints = new LinkedHashMap();
        NodeList constraints = WebXml.getNodeList(webXml, xpath, XPATH_SECURITY_CONSTRAINT);
        for (int i = 0; i < constraints.getLength(); ++i) {
            int j;
            Node constraint = constraints.item(i);
            Set<String> roles = null;
            NodeList auth = WebXml.getNodeList(constraint, xpath, XPATH_AUTH_CONSTRAINT);
            if (auth.getLength() > 0) {
                NodeList authRoles = WebXml.getNodeList(constraint, xpath, XPATH_AUTH_CONSTRAINT_ROLE_NAME);
                roles = new HashSet<String>(authRoles.getLength());
                for (j = 0; j < authRoles.getLength(); ++j) {
                    roles.add(authRoles.item(j).getTextContent().trim());
                }
                roles = Collections.unmodifiableSet(roles);
            }
            NodeList urlPatterns = WebXml.getNodeList(constraint, xpath, XPATH_WEB_RESOURCE_URL_PATTERN);
            for (j = 0; j < urlPatterns.getLength(); ++j) {
                String urlPattern = urlPatterns.item(j).getTextContent().trim();
                securityConstraints.put(urlPattern, roles);
            }
        }
        return Collections.unmodifiableMap(securityConstraints);
    }

    private static int parseSessionTimeout(Element webXml, XPath xpath) throws Exception {
        String sessionTimeout = xpath.compile(XPATH_SESSION_TIMEOUT).evaluate(webXml).trim();
        return Utils.isNumber(sessionTimeout) ? Integer.parseInt(sessionTimeout) : -1;
    }

    private static NodeList getNodeList(Node node, XPath xpath, String expression) throws Exception {
        return (NodeList)xpath.compile(expression).evaluate(node, XPathConstants.NODESET);
    }

    static {
        logger = Logger.getLogger(WebXml.class.getName());
    }
}

