/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.effect;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.primefaces.component.effect.Effect;
import org.primefaces.component.effect.EffectBuilder;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class EffectRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Effect effect = (Effect)component;
        String clientId = effect.getClientId(context);
        String source = component.getParent().getClientId(context);
        String event = effect.getEvent();
        int delay = effect.getDelay();
        UIComponent targetComponent = SearchExpressionFacade.resolveComponentWithParentFallback(context, (UIComponent)effect, effect.getFor());
        String target = targetComponent.getClientId(context);
        String animation = this.getEffectBuilder(effect, target).build();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Effect", effect.resolveWidgetVar(), clientId).attr("source", source).attr("event", event).attr("delay", delay).callback("fn", "function()", animation);
        wb.finish();
    }

    private EffectBuilder getEffectBuilder(Effect effect, String effectedComponentClientId) {
        EffectBuilder effectBuilder = new EffectBuilder(effect.getType(), effectedComponentClientId);
        for (UIComponent child : effect.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            effectBuilder.withOption(param.getName(), (String)param.getValue());
        }
        effectBuilder.atSpeed(effect.getSpeed());
        return effectBuilder;
    }
}

