/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.HashSet;
import java.util.Set;

public final class ResourcePaths {
    private ResourcePaths() {
    }

    public static boolean isDirectory(String resourcePath) {
        return resourcePath.endsWith("/");
    }

    public static String stripPrefixPath(String prefix, String resource) {
        String normalizedResource = resource;
        if (normalizedResource.startsWith(prefix)) {
            normalizedResource = normalizedResource.substring(prefix.length() - 1);
        }
        return normalizedResource;
    }

    public static String stripExtension(String resource) {
        String normalizedResource = resource;
        int lastPeriod = resource.lastIndexOf(46);
        if (lastPeriod != -1) {
            normalizedResource = resource.substring(0, lastPeriod);
        }
        return normalizedResource;
    }

    public static String getExtension(String resource) {
        String extension = null;
        int lastPeriod = resource.lastIndexOf(46);
        if (lastPeriod != -1) {
            extension = resource.substring(lastPeriod);
        }
        return extension;
    }

    public static boolean isExtensionless(String viewId) {
        return viewId != null && !viewId.contains(".");
    }

    public static Set<String> filterExtension(Set<String> resources) {
        HashSet<String> filteredResources = new HashSet<String>();
        for (String resource : resources) {
            if (!ResourcePaths.isExtensionless(resource)) continue;
            filteredResources.add(resource);
        }
        return filteredResources;
    }
}

