/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.resourcehandler.CDNResourceHandler;
import org.omnifaces.resourcehandler.CombinedResource;
import org.omnifaces.resourcehandler.CombinedResourceInfo;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Events;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class CombinedResourceHandler
extends ResourceHandlerWrapper
implements SystemEventListener {
    public static final String LIBRARY_NAME = "omnifaces.combined";
    public static final String PARAM_NAME_EXCLUDED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_EXCLUDED_RESOURCES";
    public static final String PARAM_NAME_SUPPRESSED_RESOURCES = "org.omnifaces.COMBINED_RESOURCE_HANDLER_SUPPRESSED_RESOURCES";
    public static final String PARAM_NAME_INLINE_CSS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_CSS";
    public static final String PARAM_NAME_INLINE_JS = "org.omnifaces.COMBINED_RESOURCE_HANDLER_INLINE_JS";
    private static final String TARGET_HEAD = "head";
    private static final String ATTRIBUTE_RESOURCE_LIBRARY = "library";
    private static final String ATTRIBUTE_RESOURCE_NAME = "name";
    private ResourceHandler wrapped;
    private Set<ResourceIdentifier> excludedResources;
    private Set<ResourceIdentifier> suppressedResources;
    private boolean inlineCSS;
    private boolean inlineJS;

    public CombinedResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        if (!Faces.isDevelopment()) {
            this.excludedResources = CombinedResourceHandler.initResources(PARAM_NAME_EXCLUDED_RESOURCES);
            this.excludedResources.addAll(CombinedResourceHandler.initCDNResources());
            this.suppressedResources = CombinedResourceHandler.initResources(PARAM_NAME_SUPPRESSED_RESOURCES);
            this.excludedResources.addAll(this.suppressedResources);
            this.inlineCSS = Boolean.valueOf(Faces.getInitParameter(PARAM_NAME_INLINE_CSS));
            this.inlineJS = Boolean.valueOf(Faces.getInitParameter(PARAM_NAME_INLINE_JS));
            Events.subscribeToEvent(PreRenderViewEvent.class, this);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        CombinedResourceBuilder builder = new CombinedResourceBuilder();
        for (UIComponent componentResource : context.getViewRoot().getComponentResources(context, TARGET_HEAD)) {
            String library = (String)componentResource.getAttributes().get(ATTRIBUTE_RESOURCE_LIBRARY);
            String name = (String)componentResource.getAttributes().get(ATTRIBUTE_RESOURCE_NAME);
            if (name == null) continue;
            ResourceIdentifier resourceIdentifier = new ResourceIdentifier(library, name);
            builder.add(context, componentResource, componentResource.getRendererType(), resourceIdentifier);
        }
        builder.create(context);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if (LIBRARY_NAME.equals(libraryName)) {
            return new CombinedResource(resourceName);
        }
        return this.wrapped.createResource(resourceName, libraryName, contentType);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        if (LIBRARY_NAME.equals(context.getExternalContext().getRequestParameterMap().get("ln"))) {
            try {
                CombinedResourceHandler.streamResource(context, new CombinedResource(context));
            }
            catch (IllegalArgumentException e) {
                context.getExternalContext().responseSendError(404, Faces.getRequestURI());
            }
        } else {
            this.wrapped.handleResourceRequest(context);
        }
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    private static Set<ResourceIdentifier> initResources(String name) {
        HashSet<ResourceIdentifier> resources = new HashSet<ResourceIdentifier>(1);
        String configuredResources = Faces.getInitParameter(name);
        if (configuredResources != null) {
            for (String resourceIdentifier : configuredResources.split("\\s*,\\s*")) {
                resources.add(new ResourceIdentifier(resourceIdentifier));
            }
        }
        return resources;
    }

    private static Set<ResourceIdentifier> initCDNResources() {
        Map<ResourceIdentifier, String> cdnResources = CDNResourceHandler.initCDNResources();
        return cdnResources != null ? cdnResources.keySet() : Collections.emptySet();
    }

    private static void streamResource(FacesContext context, Resource resource) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        if (!resource.userAgentNeedsUpdate(context)) {
            externalContext.setResponseStatus(304);
            return;
        }
        externalContext.setResponseContentType(resource.getContentType());
        for (Map.Entry header : resource.getResponseHeaders().entrySet()) {
            externalContext.setResponseHeader((String)header.getKey(), (String)header.getValue());
        }
        Utils.stream(resource.getInputStream(), externalContext.getResponseOutputStream());
    }

    private final class CombinedResourceBuilder {
        private static final String RENDERER_TYPE_CSS = "javax.faces.resource.Stylesheet";
        private static final String RENDERER_TYPE_JS = "javax.faces.resource.Script";
        private static final String EXTENSION_CSS = ".css";
        private static final String EXTENSION_JS = ".js";
        private CombinedResourceBuilder stylesheets;
        private CombinedResourceBuilder scripts;
        private List<UIComponent> componentResourcesToRemove;
        private String extension;
        private CombinedResourceInfo.Builder info;
        private UIComponent componentResource;

        public CombinedResourceBuilder() {
            this.stylesheets = new CombinedResourceBuilder(EXTENSION_CSS);
            this.scripts = new CombinedResourceBuilder(EXTENSION_JS);
            this.componentResourcesToRemove = new ArrayList<UIComponent>(3);
        }

        public void add(FacesContext context, UIComponent component, String rendererType, ResourceIdentifier id) {
            if (CombinedResourceHandler.LIBRARY_NAME.equals(id.getLibrary())) {
                CombinedResourceInfo info = CombinedResourceInfo.get(id.getName());
                if (info != null) {
                    for (ResourceIdentifier combinedId : info.getResourceIdentifiers()) {
                        this.add(context, null, rendererType, combinedId);
                    }
                }
                this.componentResourcesToRemove.add(component);
            } else if (rendererType.equals(RENDERER_TYPE_CSS)) {
                this.stylesheets.add(component, id.getLibrary(), id.getName());
            } else if (rendererType.equals(RENDERER_TYPE_JS)) {
                this.scripts.add(component, id.getLibrary(), id.getName());
            } else if (Hacks.isRichFacesResourceLibraryRenderer(rendererType)) {
                Set<ResourceIdentifier> resourceIdentifiers = Hacks.getRichFacesResourceLibraryResources(id);
                ResourceHandler handler = context.getApplication().getResourceHandler();
                for (ResourceIdentifier identifier : resourceIdentifiers) {
                    rendererType = handler.getRendererTypeForResourceName(identifier.getName());
                    this.add(context, null, rendererType, identifier);
                }
                this.componentResourcesToRemove.add(component);
            }
        }

        public void create(FacesContext context) {
            this.stylesheets.create(context, CombinedResourceHandler.this.inlineCSS ? "org.omnifaces.InlineStylesheet" : RENDERER_TYPE_CSS);
            this.scripts.create(context, CombinedResourceHandler.this.inlineJS ? "org.omnifaces.InlineScript" : RENDERER_TYPE_JS);
            this.removeComponentResources(context);
        }

        private void removeComponentResources(FacesContext context) {
            for (UIComponent resourceToRemove : this.componentResourcesToRemove) {
                if (resourceToRemove == null) continue;
                context.getViewRoot().removeComponentResource(context, resourceToRemove, CombinedResourceHandler.TARGET_HEAD);
            }
        }

        private CombinedResourceBuilder(String extension) {
            this.extension = extension;
            this.info = new CombinedResourceInfo.Builder();
            this.componentResourcesToRemove = new ArrayList<UIComponent>(3);
        }

        private void add(UIComponent componentResource, String library, String name) {
            ResourceIdentifier resourceIdentifier = new ResourceIdentifier(library, name);
            if (CombinedResourceHandler.this.excludedResources.isEmpty() || !CombinedResourceHandler.this.excludedResources.contains(resourceIdentifier)) {
                this.info.add(resourceIdentifier);
                if (this.componentResource == null) {
                    this.componentResource = componentResource;
                } else {
                    this.componentResourcesToRemove.add(componentResource);
                }
            } else if (CombinedResourceHandler.this.suppressedResources.contains(resourceIdentifier)) {
                this.componentResourcesToRemove.add(componentResource);
            }
        }

        private void create(FacesContext context, String rendererType) {
            if (!this.info.isEmpty()) {
                if (this.componentResource == null) {
                    this.componentResource = new UIOutput();
                    context.getViewRoot().addComponentResource(context, this.componentResource, CombinedResourceHandler.TARGET_HEAD);
                }
                this.componentResource.getAttributes().put(CombinedResourceHandler.ATTRIBUTE_RESOURCE_LIBRARY, CombinedResourceHandler.LIBRARY_NAME);
                this.componentResource.getAttributes().put(CombinedResourceHandler.ATTRIBUTE_RESOURCE_NAME, this.info.create() + this.extension);
                this.componentResource.setRendererType(rendererType);
            }
            this.removeComponentResources(context);
        }
    }
}

