/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.facesviews.ExtensionAction;
import org.omnifaces.facesviews.FacesServletDispatchMethod;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.facesviews.FacesViewsViewHandler;
import org.omnifaces.facesviews.PathAction;
import org.omnifaces.facesviews.UriExtensionRequestWrapper;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;

public class FacesViewsForwardingFilter
extends HttpFilter {
    private static ExtensionAction extensionAction;
    private static PathAction pathAction;
    private static FacesServletDispatchMethod dispatchMethod;
    private static AtomicBoolean initDone;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!initDone.getAndSet(true)) {
            ServletContext servletContext = filterConfig.getServletContext();
            FacesViews.tryScanAndStoreViews(servletContext);
            Application application = Faces.getApplicationFromFactory();
            application.setViewHandler((ViewHandler)new FacesViewsViewHandler(application.getViewHandler()));
            extensionAction = FacesViews.getExtensionAction(servletContext);
            pathAction = FacesViews.getPathAction(servletContext);
            dispatchMethod = FacesViews.getFacesServletDispatchMethod(servletContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        block22: {
            Map reverseResources;
            String resource;
            Map<String, String> resources;
            ServletContext context;
            block21: {
                context = this.getServletContext();
                resources = (Map<String, String>)Servlets.getApplicationAttribute(context, "org.omnifaces.facesviews");
                resource = request.getServletPath();
                if (!ResourcePaths.isExtensionless(resource)) break block21;
                if (Faces.getApplicationFromFactory().getProjectStage() == ProjectStage.Development && !resources.containsKey(resource)) {
                    resources = FacesViews.scanAndStoreViews(context);
                }
                if (!resources.containsKey(resource)) break block22;
                String extension = ResourcePaths.getExtension(resources.get(resource));
                switch (dispatchMethod) {
                    case DO_FILTER: {
                        try {
                            request.setAttribute("org.omnifaces.facesviews.original.servlet_path", (Object)request.getServletPath());
                            chain.doFilter((ServletRequest)new UriExtensionRequestWrapper(request, extension), (ServletResponse)response);
                        }
                        finally {
                            request.removeAttribute("org.omnifaces.facesviews.original.servlet_path");
                        }
                        return;
                    }
                    case FORWARD: {
                        RequestDispatcher requestDispatcher = context.getRequestDispatcher(resource + extension);
                        if (requestDispatcher == null) break;
                        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                }
                break block22;
            }
            if (resources.containsKey(resource)) {
                switch (extensionAction) {
                    case REDIRECT_TO_EXTENSIONLESS: {
                        FacesViewsForwardingFilter.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request));
                        return;
                    }
                    case SEND_404: {
                        response.sendError(404);
                        return;
                    }
                    case PROCEED: {
                        break;
                    }
                }
            } else if (FacesViews.isResourceInPublicPath(context, resource) && (reverseResources = (Map)Servlets.getApplicationAttribute(context, "org.omnifaces.facesviews.reverse.resources")).containsKey(resource)) {
                switch (pathAction) {
                    case REDIRECT_TO_SCANNED_EXTENSIONLESS: {
                        FacesViewsForwardingFilter.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request, (String)reverseResources.get(resource)));
                        return;
                    }
                    case SEND_404: {
                        response.sendError(404);
                        return;
                    }
                    case PROCEED: {
                        break;
                    }
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static void redirectPermanent(HttpServletResponse response, String url) {
        response.setStatus(301);
        response.setHeader("Location", url);
        response.setHeader("Connection", "close");
    }

    static {
        initDone = new AtomicBoolean();
    }
}

