/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.omnifaces.eventlistener.DefaultPhaseListener;
import org.omnifaces.util.Hacks;

public class ResetInputAjaxActionListener
extends DefaultPhaseListener
implements ActionListener {
    private static final long serialVersionUID = -5317382021715077662L;
    private static final Set<VisitHint> VISIT_HINTS = EnumSet.of(VisitHint.SKIP_TRANSIENT, VisitHint.SKIP_UNRENDERED);
    private ActionListener wrapped;

    public ResetInputAjaxActionListener() {
        this((ActionListener)null);
    }

    public ResetInputAjaxActionListener(ActionListener wrapped) {
        super(PhaseId.INVOKE_APPLICATION);
        this.wrapped = wrapped;
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        this.processAction(null);
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        PartialViewContext partialViewContext = context.getPartialViewContext();
        if (partialViewContext.isAjaxRequest()) {
            Collection<String> renderIds = ResetInputAjaxActionListener.getRenderIds(partialViewContext);
            Collection executeIds = partialViewContext.getExecuteIds();
            if (!renderIds.isEmpty() && !renderIds.containsAll(executeIds)) {
                this.resetEditableValueHolders(VisitContext.createVisitContext((FacesContext)context, renderIds, VISIT_HINTS), (UIComponent)context.getViewRoot(), executeIds);
            }
        }
        if (this.wrapped != null && event != null) {
            this.wrapped.processAction(event);
        }
    }

    private static Collection<String> getRenderIds(PartialViewContext partialViewContext) {
        Collection<String> renderIds = partialViewContext.getRenderIds();
        if (renderIds.isEmpty() && Hacks.isRichFacesInstalled()) {
            renderIds = Hacks.getRichFacesRenderIds();
        }
        return renderIds;
    }

    private void resetEditableValueHolders(VisitContext context, UIComponent component, final Collection<String> executeIds) {
        component.visitTree(context, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (executeIds.contains(target.getClientId(context.getFacesContext()))) {
                    return VisitResult.REJECT;
                }
                if (target instanceof EditableValueHolder) {
                    ((EditableValueHolder)target).resetValue();
                } else if (context.getIdsToVisit() != VisitContext.ALL_IDS) {
                    ResetInputAjaxActionListener.this.resetEditableValueHolders(VisitContext.createVisitContext((FacesContext)context.getFacesContext(), null, (Set)context.getHints()), target, executeIds);
                }
                return VisitResult.ACCEPT;
            }
        });
    }
}

