/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import org.omnifaces.el.ELContextWrapper;
import org.omnifaces.el.ELResolverWrapper;
import org.omnifaces.el.MethodReference;

public class ExpressionInspector {
    public static ValueReference getValueReference(ELContext context, ValueExpression valueExpression) {
        InspectorElContext inspectorElContext = new InspectorElContext(context);
        valueExpression.getType((ELContext)inspectorElContext);
        return new ValueReference(inspectorElContext.getBase(), inspectorElContext.getProperty());
    }

    public static MethodReference getMethodReference(ELContext context, ValueExpression valueExpression) {
        ValueReference valueReference = ExpressionInspector.getValueReference(context, valueExpression);
        return new MethodReference(valueReference.getBase(), ExpressionInspector.findMethod(valueReference.getBase(), valueReference.getProperty().toString()));
    }

    public static Method findMethod(Object base, String methodName) {
        for (Method method : base.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    static class InspectorElResolver
    extends ELResolverWrapper {
        private int findOneButLastCallCount;
        private int findLastCallCount;
        private Object lastBase;
        private Object lastProperty;
        private boolean findOneButLast = true;

        public InspectorElResolver(ELResolver elResolver) {
            super(elResolver);
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            if (this.recordCall(base, property)) {
                return super.getValue(context, base, property);
            }
            context.setPropertyResolved(true);
            return null;
        }

        @Override
        public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
            if (this.recordCall(base, method)) {
                return super.invoke(context, base, method, paramTypes, params);
            }
            context.setPropertyResolved(true);
            return null;
        }

        @Override
        public Class<?> getType(ELContext context, Object base, Object property) {
            this.lastBase = base;
            this.lastProperty = property;
            context.setPropertyResolved(true);
            return null;
        }

        private boolean recordCall(Object base, Object property) {
            if (this.findOneButLast) {
                ++this.findOneButLastCallCount;
                this.lastBase = base;
                this.lastProperty = property;
            } else {
                ++this.findLastCallCount;
                if (this.findLastCallCount == this.findOneButLastCallCount) {
                    if (base != this.lastBase || property != this.lastProperty) {
                        System.out.print("Error! Not equal!");
                    }
                } else if (this.findLastCallCount == this.findOneButLastCallCount + 1) {
                    this.lastBase = base;
                    this.lastProperty = property;
                    return false;
                }
            }
            return true;
        }

        public boolean isFindOneButLast() {
            return this.findOneButLast;
        }

        public void setFindOneButLast(boolean findOneButLast) {
            this.findOneButLast = findOneButLast;
        }

        public Object getBase() {
            return this.lastBase;
        }

        public Object getProperty() {
            return this.lastProperty;
        }
    }

    static class InspectorElContext
    extends ELContextWrapper {
        private final InspectorElResolver inspectorElResolver = new InspectorElResolver(super.getELResolver());

        public InspectorElContext(ELContext elContext) {
            super(elContext);
        }

        @Override
        public ELResolver getELResolver() {
            return this.inspectorElResolver;
        }

        public boolean isFindOneButLast() {
            return this.inspectorElResolver.isFindOneButLast();
        }

        public void setFindOneButLast(boolean findOneButLast) {
            this.inspectorElResolver.setFindOneButLast(findOneButLast);
        }

        public Object getBase() {
            return this.inspectorElResolver.getBase();
        }

        public Object getProperty() {
            return this.inspectorElResolver.getProperty();
        }
    }
}

