/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output.cache;

import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.omnifaces.component.output.cache.Cache;
import org.omnifaces.component.output.cache.CacheProvider;
import org.omnifaces.component.output.cache.DefaultCacheProvider;

public final class CacheFactory {
    public static final String CACHE_PROVIDER_PARAM_NAME = "org.omnifaces.cacheprovider";
    private static final CacheProvider DEFAULT_PROVIDER = new DefaultCacheProvider();

    private CacheFactory() {
    }

    public static Cache getCache(FacesContext context, String scope) {
        return CacheFactory.getCacheProvider(context).getCache(context, scope);
    }

    public static CacheProvider getCacheProvider(ServletContext servletContext) {
        return (CacheProvider)servletContext.getAttribute(CACHE_PROVIDER_PARAM_NAME);
    }

    public static void setCacheProvider(CacheProvider cacheProvider, ServletContext servletContext) {
        servletContext.setAttribute(CACHE_PROVIDER_PARAM_NAME, (Object)cacheProvider);
    }

    public static CacheProvider getCacheProvider(FacesContext context) {
        CacheProvider provider = (CacheProvider)context.getExternalContext().getApplicationMap().get(CACHE_PROVIDER_PARAM_NAME);
        return provider != null ? provider : DEFAULT_PROVIDER;
    }

    public static CacheProvider getDefaultCacheProvider() {
        return DEFAULT_PROVIDER;
    }
}

