/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.omnifaces.util.Utils;

public class IterableDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Iterable<E> iterable;
    private List<E> list;

    public IterableDataModel(Iterable<E> iterable) {
        this.setWrappedData(iterable);
    }

    public boolean isRowAvailable() {
        return this.list != null && this.index >= 0 && this.index < this.list.size();
    }

    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public E getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalStateException();
        }
        return this.list.get(this.index);
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldRowIndex = this.index;
        this.index = rowIndex;
        if (this.list == null) {
            return;
        }
        this.notifyListeners(oldRowIndex, rowIndex);
    }

    public Object getWrappedData() {
        return this.iterable;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.list = null;
            this.iterable = null;
            this.setRowIndex(-1);
        } else {
            this.iterable = (Iterable)data;
            this.list = Utils.iterableToList(this.iterable);
            this.setRowIndex(0);
        }
    }

    private E getRowDataOrNull() {
        if (this.isRowAvailable()) {
            return this.getRowData();
        }
        return null;
    }

    private void notifyListeners(int oldRowIndex, int rowIndex) {
        DataModelListener[] dataModelListeners = this.getDataModelListeners();
        if (oldRowIndex != rowIndex && dataModelListeners != null) {
            DataModelEvent dataModelEvent = new DataModelEvent((DataModel)this, rowIndex, this.getRowDataOrNull());
            for (DataModelListener dataModelListener : dataModelListeners) {
                if (dataModelListener == null) continue;
                dataModelListener.rowSelected(dataModelEvent);
            }
        }
    }
}

