/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class HttpFilter
implements Filter {
    private static final String ERROR_NO_FILTERCONFIG = "FilterConfig is not available. It seems that you've overriden HttpFilter#init(FilterConfig). You should be overriding HttpFilter#init() instead, otherwise you have to call super.init(config).";
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.init();
    }

    public void init() throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        this.doFilter(httpRequest, httpResponse, session, chain);
    }

    public abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, HttpSession var3, FilterChain var4) throws ServletException, IOException;

    public void destroy() {
        this.filterConfig = null;
    }

    protected FilterConfig getFilterConfig() {
        this.checkFilterConfig();
        return this.filterConfig;
    }

    protected String getInitParameter(String name) {
        this.checkFilterConfig();
        return this.filterConfig.getInitParameter(name);
    }

    protected ServletContext getServletContext() {
        this.checkFilterConfig();
        return this.filterConfig.getServletContext();
    }

    private void checkFilterConfig() {
        if (this.filterConfig == null) {
            throw new IllegalStateException(ERROR_NO_FILTERCONFIG);
        }
    }
}

