/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.selectitems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.omnifaces.el.ScopedRunner;
import org.omnifaces.model.ExtendedSelectItem;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsBuilder;

public final class SelectItemsCollector {
    private static final String ERROR_UNKNOWN_SELECT_TYPE = "A value expression of type '%s' is disallowed for a select item";

    private SelectItemsCollector() {
    }

    public static List<SelectItem> collectFromParent(FacesContext context, UIComponent parent) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : parent.getChildren()) {
            Object value;
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                value = uiSelectItem.getValue();
                if (value instanceof SelectItem) {
                    selectItems.add((SelectItem)value);
                    continue;
                }
                if (uiSelectItem.getValue() == null) {
                    selectItems.add(new ExtendedSelectItem(uiSelectItem));
                    continue;
                }
                throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_SELECT_TYPE, value.getClass().toString()));
            }
            if (!(child instanceof UISelectItems)) continue;
            UISelectItems uiSelectItems = (UISelectItems)child;
            value = uiSelectItems.getValue();
            if (value instanceof SelectItem) {
                selectItems.add((SelectItem)value);
                continue;
            }
            if (value instanceof Object[]) {
                selectItems.addAll(SelectItemsCollector.collectFromUISelectItemsIterator(context, uiSelectItems, Arrays.asList((Object[])value)));
                continue;
            }
            if (value instanceof Iterable) {
                selectItems.addAll(SelectItemsCollector.collectFromUISelectItemsIterator(context, uiSelectItems, (Iterable)value));
                continue;
            }
            if (value instanceof Map) {
                selectItems.addAll(SelectItemsBuilder.fromMap((Map)value));
                continue;
            }
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_SELECT_TYPE, value.getClass().toString()));
        }
        return selectItems;
    }

    public static List<SelectItem> collectFromUISelectItemsIterator(FacesContext facesContext, UISelectItems uiSelectItems, Iterable<?> items) {
        final ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        final Map attributes = uiSelectItems.getAttributes();
        String var = (String)attributes.get("var");
        ScopedRunner scopedRunner = new ScopedRunner(facesContext);
        for (final Object item : items) {
            if (item instanceof SelectItem) {
                selectItems.add((SelectItem)item);
                continue;
            }
            if (!Utils.isEmpty(var)) {
                scopedRunner.with(var, item);
            }
            scopedRunner.invoke(new Callback.Void(){

                @Override
                public void invoke() {
                    Object itemValue = SelectItemsCollector.getItemValue(attributes, item);
                    Object noSelectionValue = attributes.get("noSelectionValue");
                    boolean itemValueIsNoSelectionValue = noSelectionValue != null && noSelectionValue.equals(itemValue);
                    selectItems.add(new SelectItem(itemValue, SelectItemsCollector.getItemLabel(attributes, itemValue), SelectItemsCollector.getItemDescription(attributes), SelectItemsCollector.getBooleanAttribute(attributes, "itemDisabled", false), SelectItemsCollector.getBooleanAttribute(attributes, "itemLabelEscaped", true), SelectItemsCollector.getBooleanAttribute(attributes, "noSelectionOption", false) || itemValueIsNoSelectionValue));
                }
            });
        }
        return selectItems;
    }

    private static Object getItemValue(Map<String, Object> attributes, Object item) {
        Object itemValue = attributes.get("itemValue");
        if (itemValue == null) {
            itemValue = item;
        }
        return itemValue;
    }

    private static String getItemLabel(Map<String, Object> attributes, Object itemValue) {
        Object itemLabelObj = attributes.get("itemLabel");
        String itemLabel = null;
        itemLabel = itemLabelObj != null ? itemLabelObj.toString() : itemValue.toString();
        return itemLabel;
    }

    private static String getItemDescription(Map<String, Object> attributes) {
        Object itemDescriptionObj = attributes.get("itemDescription");
        String itemDescription = null;
        if (itemDescriptionObj != null) {
            itemDescription = itemDescriptionObj.toString();
        }
        return itemDescription;
    }

    private static boolean getBooleanAttribute(Map<String, Object> attributes, String key, boolean defaultValue) {
        Object valueObj = attributes.get(key);
        boolean value = defaultValue;
        if (valueObj != null) {
            value = Boolean.parseBoolean(valueObj.toString());
        }
        return value;
    }
}

