/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.eventlistener.BeanValidationEventListener;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;

public class ValidateBean
extends TagHandler {
    private static final String ERROR_INVALID_PARENT = "Parent component of o:validateBean must be an instance of UICommand or UIInput.";
    private TagAttribute validationGroups = this.getAttribute("validationGroups");
    private TagAttribute disabled = this.getAttribute("disabled");

    public ValidateBean(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, final UIComponent parent) throws IOException {
        if (!(parent instanceof UICommand) && !(parent instanceof UIInput)) {
            throw new IllegalArgumentException(ERROR_INVALID_PARENT);
        }
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        final String validationGroups = this.validationGroups != null ? this.validationGroups.getValue(context) : null;
        final boolean disabled = this.disabled != null ? this.disabled.getBoolean(context) : false;
        Events.addBeforePhaseListener(PhaseId.PROCESS_VALIDATIONS, new Callback.Void(){

            @Override
            public void invoke() {
                if (Components.hasInvokedSubmit(parent)) {
                    BeanValidationEventListener listener = new BeanValidationEventListener(validationGroups, disabled);
                    Events.subscribeToViewEvent(PreValidateEvent.class, listener);
                    Events.subscribeToViewEvent(PostValidateEvent.class, listener);
                }
            }
        });
    }
}

