/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Strings {
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this machine.";

    private Strings() {
    }

    public static String abbreviate(String text, int size) {
        if (text == null) {
            return null;
        }
        if (text.length() > size) {
            text = text.substring(0, size).trim() + "...";
        }
        return text;
    }

    public static String concat(Object left, Object right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right.toString();
        }
        if (right == null) {
            return left.toString();
        }
        return left.toString() + right.toString();
    }

    public static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    public static String replaceAll(String value, String pattern, String replacement) {
        if (value == null) {
            return null;
        }
        return value.replaceAll(pattern, replacement);
    }

    public static boolean matches(String value, String pattern) {
        return value != null && value.matches(pattern);
    }

    public static String prettyURL(String string) {
        if (string == null) {
            return null;
        }
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{Alnum}]+", "-");
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING);
        }
    }

    public static String escapeJS(String string) {
        return Utils.escapeJS(string, true);
    }

    public static String format1(String pattern, Object param1) {
        return Strings.format(pattern, param1);
    }

    public static String format2(String pattern, Object param1, Object param2) {
        return Strings.format(pattern, param1, param2);
    }

    public static String format3(String pattern, Object param1, Object param2, Object param3) {
        return Strings.format(pattern, param1, param2, param3);
    }

    public static String format4(String pattern, Object param1, Object param2, Object param3, Object param4) {
        return Strings.format(pattern, param1, param2, param3, param4);
    }

    public static String format5(String pattern, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return Strings.format(pattern, param1, param2, param3, param4, param5);
    }

    private static String format(String pattern, Object ... params) {
        StringBuffer result = new StringBuffer();
        new MessageFormat(pattern, Faces.getLocale()).format(params, result, (FieldPosition)null);
        return result.toString();
    }
}

