/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.tree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.omnifaces.component.EditableValueHolderStateHelper;
import org.omnifaces.component.tree.TreeFamily;
import org.omnifaces.component.tree.TreeNode;
import org.omnifaces.event.FacesEventWrapper;
import org.omnifaces.model.tree.ListTreeModel;
import org.omnifaces.model.tree.TreeModel;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.component.tree.Tree")
public class Tree
extends TreeFamily
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.tree.Tree";
    private static final String ERROR_EXPRESSION_DISALLOWED = "A value expression is disallowed on 'var' and 'varNode' attributes of Tree.";
    private static final String ERROR_INVALID_MODEL = "Tree accepts only model of type TreeModel. Encountered model of type '%s'.";
    private static final String ERROR_NESTING_DISALLOWED = "Nesting Tree components is disallowed. Use TreeNode instead to markup specific levels.";
    private static final String ERROR_NO_CHILDREN = "Tree must have children of type TreeNode. Currently none are encountered.";
    private static final String ERROR_INVALID_CHILD = "Tree accepts only children of type TreeNode. Encountered child of type '%s'.";
    private static final String ERROR_DUPLICATE_NODE = "TreeNode with level '%s' is already declared. Choose a different level or remove it.";
    private final State state = new State(this.getStateHelper());
    private TreeModel model;
    private Map<Integer, TreeNode> nodes;
    private TreeModel currentModelNode;

    public String getContainerClientId(FacesContext context) {
        String currentModelNodeIndex;
        String containerClientId = super.getContainerClientId(context);
        String string = currentModelNodeIndex = this.currentModelNode != null ? this.currentModelNode.getIndex() : null;
        if (currentModelNodeIndex != null) {
            containerClientId = containerClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + currentModelNodeIndex;
        }
        return containerClientId;
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (PropertyKeys.var.toString().equals(name) || PropertyKeys.varNode.toString().equals(name)) {
            throw new IllegalArgumentException(ERROR_EXPRESSION_DISALLOWED);
        }
        super.setValueExpression(name, binding);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new TreeFacesEvent(event, this, this.getCurrentModelNode()));
    }

    @Override
    protected void validateHierarchy() {
        if (Components.getClosestParent((UIComponent)this, Tree.class) != null) {
            throw new IllegalArgumentException(ERROR_NESTING_DISALLOWED);
        }
        if (this.getChildCount() == 0) {
            throw new IllegalArgumentException(ERROR_NO_CHILDREN);
        }
    }

    @Override
    protected void process(final FacesContext context, final PhaseId phaseId) {
        if (!this.isRendered()) {
            return;
        }
        this.process(context, phaseId, this.getModel(phaseId), new Callback.Returning<Void>(){

            @Override
            public Void invoke() {
                Tree.this.processTreeNode(context, phaseId);
                return null;
            }
        });
    }

    public boolean visitTree(final VisitContext context, final VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        PhaseId phaseId = PhaseId.ANY_PHASE;
        return this.process(context.getFacesContext(), phaseId, this.getModel(phaseId), new Callback.Returning<Boolean>(){

            @Override
            public Boolean invoke() {
                VisitResult result = context.invokeVisitCallback((UIComponent)Tree.this, callback);
                if (result == VisitResult.COMPLETE) {
                    return true;
                }
                if (result == VisitResult.ACCEPT && !context.getSubtreeIdsToVisit((UIComponent)Tree.this).isEmpty()) {
                    return Tree.this.visitTreeNode(context, callback);
                }
                return false;
            }
        });
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof TreeFacesEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            TreeFacesEvent treeEvent = (TreeFacesEvent)event;
            final FacesEvent wrapped = treeEvent.getWrapped();
            this.process(context, event.getPhaseId(), treeEvent.getNode(), new Callback.Returning<Void>(){

                @Override
                public Void invoke() {
                    wrapped.getComponent().broadcast(wrapped);
                    return null;
                }
            });
        } else {
            super.broadcast(event);
        }
    }

    protected void processTreeNode(final FacesContext context, final PhaseId phaseId) {
        this.processTreeNode(phaseId, new Callback.ReturningWithArgument<Void, TreeNode>(){

            @Override
            public Void invoke(TreeNode treeNode) {
                if (treeNode != null) {
                    treeNode.process(context, phaseId);
                }
                return null;
            }
        });
    }

    protected boolean visitTreeNode(final VisitContext context, final VisitCallback callback) {
        return this.processTreeNode(PhaseId.ANY_PHASE, new Callback.ReturningWithArgument<Boolean, TreeNode>(){

            @Override
            public Boolean invoke(TreeNode treeNode) {
                if (treeNode != null) {
                    return treeNode.visitTree(context, callback);
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R process(FacesContext context, PhaseId phaseId, TreeModel node, Callback.Returning<R> callback) {
        Object[] originalVars = this.captureOriginalVars(context);
        TreeModel originalModelNode = this.currentModelNode;
        this.pushComponentToEL(context, null);
        try {
            this.setCurrentModelNode(context, node);
            R r = callback.invoke();
            return r;
        }
        finally {
            this.popComponentFromEL(context);
            this.setCurrentModelNode(context, originalModelNode);
            this.setVars(context, originalVars);
        }
    }

    private <R> R processTreeNode(PhaseId phaseId, Callback.ReturningWithArgument<R, TreeNode> callback) {
        Map<Integer, TreeNode> nodes;
        TreeNode treeNode = null;
        if (!this.currentModelNode.isLeaf() && (treeNode = (nodes = this.getNodes(phaseId)).get(this.currentModelNode.getLevel())) == null) {
            treeNode = nodes.get(null);
        }
        return callback.invoke(treeNode);
    }

    private Map<Integer, TreeNode> getNodes(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE || this.nodes == null) {
            this.nodes = new HashMap<Integer, TreeNode>(this.getChildCount());
            for (UIComponent child : this.getChildren()) {
                if (child instanceof TreeNode) {
                    TreeNode node = (TreeNode)child;
                    if (this.nodes.put(node.getLevel(), node) == null) continue;
                    throw new IllegalArgumentException(String.format(ERROR_DUPLICATE_NODE, node.getLevel()));
                }
                throw new IllegalArgumentException(String.format(ERROR_INVALID_CHILD, child.getClass().getName()));
            }
        }
        return this.nodes;
    }

    private TreeModel getModel(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE || this.model == null) {
            Object value = this.getValue();
            if (value == null) {
                this.model = new ListTreeModel();
            } else if (value instanceof TreeModel) {
                this.model = (TreeModel)value;
            } else {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_MODEL, value.getClass().getName()));
            }
        }
        return this.model;
    }

    private Object[] captureOriginalVars(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String[] names = new String[]{this.getVar(), this.getVarNode()};
        Object[] vars = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            vars[i] = requestMap.get(names[i]);
        }
        return vars;
    }

    private void setVars(FacesContext context, Object ... vars) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String[] names = new String[]{this.getVar(), this.getVarNode()};
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            if (vars[i] != null) {
                requestMap.put(names[i], vars[i]);
                continue;
            }
            requestMap.remove(names[i]);
        }
    }

    protected void setCurrentModelNode(FacesContext context, TreeModel currentModelNode) {
        EditableValueHolderStateHelper.save(context, this.getStateHelper(), this.getFacetsAndChildren());
        this.currentModelNode = currentModelNode;
        this.setVars(context, currentModelNode != null ? currentModelNode.getData() : null, currentModelNode);
        EditableValueHolderStateHelper.restore(context, this.getStateHelper(), this.getFacetsAndChildren());
    }

    protected TreeModel getCurrentModelNode() {
        return this.currentModelNode;
    }

    public Object getValue() {
        return this.state.get((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.state.put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getVar() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.state.put((Serializable)((Object)PropertyKeys.var), var);
    }

    public String getVarNode() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.varNode));
    }

    public void setVarNode(String varNode) {
        this.state.put((Serializable)((Object)PropertyKeys.varNode), varNode);
    }

    private static class TreeFacesEvent
    extends FacesEventWrapper {
        private static final long serialVersionUID = -7751061713837227515L;
        private TreeModel node;

        public TreeFacesEvent(FacesEvent wrapped, Tree tree, TreeModel node) {
            super(wrapped, (UIComponent)tree);
            this.node = node;
        }

        public TreeModel getNode() {
            return this.node;
        }
    }

    private static enum PropertyKeys {
        value,
        var,
        varNode;

    }
}

