/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate.bean;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.validation.Validator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.primefaces.context.RequestContext;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.validate.bean.AssertFalseClientValidationConstraint;
import org.primefaces.validate.bean.AssertTrueClientValidationConstraint;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.ClientConstraint;
import org.primefaces.validate.bean.ClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMaxClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMinClientValidationConstraint;
import org.primefaces.validate.bean.DigitsClientValidationConstraint;
import org.primefaces.validate.bean.FutureClientValidationConstraint;
import org.primefaces.validate.bean.MaxClientValidationConstraint;
import org.primefaces.validate.bean.MinClientValidationConstraint;
import org.primefaces.validate.bean.NotNullClientValidationConstraint;
import org.primefaces.validate.bean.NullClientValidationConstraint;
import org.primefaces.validate.bean.PastClientValidationConstraint;
import org.primefaces.validate.bean.PatternClientValidationConstraint;
import org.primefaces.validate.bean.SizeClientValidationConstraint;

public class BeanValidationResolver {
    private static final Logger LOG = Logger.getLogger(BeanValidationResolver.class.getName());
    private static final Map<Class<?>, ClientValidationConstraint> CONSTRAINT_MAPPER = new HashMap();

    public static BeanValidationMetadata resolveValidationMetadata(FacesContext context, UIComponent component, RequestContext requestContext) throws IOException {
        ValueReference vr;
        ValueExpression ve = component.getValueExpression("value");
        ELContext elContext = context.getELContext();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        ArrayList<String> validatorIds = new ArrayList<String>();
        if (ve != null && (vr = ValueExpressionAnalyzer.getReference(elContext, ve)) != null) {
            Set constraints;
            PropertyDescriptor propertyDescriptor;
            BeanDescriptor beanDescriptor;
            Validator validator = requestContext.getApplicationContext().getValidatorFactory().getValidator();
            Object base = vr.getBase();
            Object property = vr.getProperty();
            if (base != null && property != null && (beanDescriptor = validator.getConstraintsForClass(base.getClass())) != null && (propertyDescriptor = beanDescriptor.getConstraintsForProperty(property.toString())) != null && (constraints = propertyDescriptor.getConstraintDescriptors()) != null && !constraints.isEmpty()) {
                for (ConstraintDescriptor constraintDescriptor : constraints) {
                    Class<?> resolvedBy;
                    Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                    ClientValidationConstraint clientValidationConstraint = CONSTRAINT_MAPPER.get(annotationType);
                    if (clientValidationConstraint != null) {
                        String validatorId = clientValidationConstraint.getValidatorId();
                        Map<String, Object> constraintMetadata = clientValidationConstraint.getMetadata(constraintDescriptor);
                        if (constraintMetadata != null) {
                            metadata.putAll(constraintMetadata);
                        }
                        if (validatorId == null) continue;
                        validatorIds.add(validatorId);
                        continue;
                    }
                    ClientConstraint clientConstraint = annotationType.getAnnotation(ClientConstraint.class);
                    if (clientConstraint == null || (resolvedBy = clientConstraint.resolvedBy()) == null) continue;
                    try {
                        ClientValidationConstraint customClientValidationConstraint = (ClientValidationConstraint)resolvedBy.newInstance();
                        String validatorId = customClientValidationConstraint.getValidatorId();
                        Map<String, Object> constraintMetadata = customClientValidationConstraint.getMetadata(constraintDescriptor);
                        if (constraintMetadata != null) {
                            metadata.putAll(constraintMetadata);
                        }
                        if (validatorId == null) continue;
                        validatorIds.add(validatorId);
                    }
                    catch (InstantiationException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return new BeanValidationMetadata(metadata, validatorIds);
    }

    static {
        CONSTRAINT_MAPPER.put(NotNull.class, new NotNullClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Null.class, new NullClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Size.class, new SizeClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Min.class, new MinClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Max.class, new MaxClientValidationConstraint());
        CONSTRAINT_MAPPER.put(DecimalMin.class, new DecimalMinClientValidationConstraint());
        CONSTRAINT_MAPPER.put(DecimalMax.class, new DecimalMaxClientValidationConstraint());
        CONSTRAINT_MAPPER.put(AssertTrue.class, new AssertTrueClientValidationConstraint());
        CONSTRAINT_MAPPER.put(AssertFalse.class, new AssertFalseClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Digits.class, new DigitsClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Past.class, new PastClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Future.class, new FutureClientValidationConstraint());
        CONSTRAINT_MAPPER.put(Pattern.class, new PatternClientValidationConstraint());
    }
}

