/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.validator;

import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;

@FacesValidator(value="omnifaces.RequiredCheckboxValidator")
public class RequiredCheckboxValidator
implements Validator {
    private static final String DEFAULT_REQUIRED_MESSAGE = "{0}: a tick is required";
    private static final String ERROR_WRONG_COMPONENT = "RequiredCheckboxValidator must be registered on a component of type UISelectBoolean. Encountered component of type '%s'.";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (!(component instanceof UISelectBoolean)) {
            throw new IllegalArgumentException(String.format(ERROR_WRONG_COMPONENT, component.getClass().getName()));
        }
        if (!Boolean.TRUE.equals(value)) {
            String requiredMessage = ((UIInput)component).getRequiredMessage();
            if (requiredMessage == null && context.getApplication().getMessageBundle() != null) {
                requiredMessage = ResourceBundle.getBundle(context.getApplication().getMessageBundle(), Faces.getLocale()).getString("javax.faces.component.UIInput.REQUIRED");
            }
            if (requiredMessage == null) {
                requiredMessage = DEFAULT_REQUIRED_MESSAGE;
            }
            throw new ValidatorException(Messages.createError(requiredMessage, Components.getLabel(component)));
        }
    }
}

