/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.RTLAware;
import org.primefaces.component.api.UITree;
import org.primefaces.component.api.Widget;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.event.TreeDragDropEvent;
import org.primefaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class Tree
extends UITree
implements Widget,
RTLAware,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Tree";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.TreeRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("select", "unselect", "expand", "collapse", "dragdrop"));
    private Map<String, UITreeNode> nodes;
    public static String CONTAINER_CLASS = "ui-tree ui-widget ui-widget-content ui-corner-all";
    public static String CONTAINER_RTL_CLASS = "ui-tree ui-tree-rtl ui-widget ui-widget-content ui-corner-all";
    public static String HORIZONTAL_CONTAINER_CLASS = "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all";
    public static String ROOT_NODES_CLASS = "ui-tree-container";
    public static String PARENT_NODE_CLASS = "ui-treenode ui-treenode-parent";
    public static String LEAF_NODE_CLASS = "ui-treenode ui-treenode-leaf";
    public static String CHILDREN_NODES_CLASS = "ui-treenode-children";
    public static String NODE_CONTENT_CLASS_V = "ui-treenode-content";
    public static String SELECTABLE_NODE_CONTENT_CLASS_V = "ui-treenode-content ui-tree-selectable";
    public static String NODE_CONTENT_CLASS_H = "ui-treenode-content ui-state-default ui-corner-all";
    public static String SELECTABLE_NODE_CONTENT_CLASS_H = "ui-treenode-content ui-tree-selectable ui-state-default ui-corner-all";
    public static String EXPANDED_ICON_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-s";
    public static String COLLAPSED_ICON_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-e";
    public static String COLLAPSED_ICON_RTL_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-w";
    public static String EXPANDED_ICON_CLASS_H = "ui-tree-toggler ui-icon ui-icon-minus";
    public static String COLLAPSED_ICON_CLASS_H = "ui-tree-toggler ui-icon ui-icon-plus";
    public static String LEAF_ICON_CLASS = "ui-treenode-leaf-icon";
    public static String NODE_ICON_CLASS = "ui-treenode-icon ui-icon";
    public static String NODE_LABEL_CLASS = "ui-treenode-label ui-corner-all";
    private TreeNode dragNode;
    private TreeNode dropNode;

    public Tree() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public boolean isDynamic() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dynamic), (Object)false);
    }

    public void setDynamic(boolean _dynamic) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dynamic), (Object)_dynamic);
    }

    public boolean isCache() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.cache), (Object)true);
    }

    public void setCache(boolean _cache) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.cache), (Object)_cache);
    }

    public String getOnNodeClick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onNodeClick), null);
    }

    public void setOnNodeClick(String _onNodeClick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onNodeClick), (Object)_onNodeClick);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public boolean isHighlight() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.highlight), (Object)true);
    }

    public void setHighlight(boolean _highlight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.highlight), (Object)_highlight);
    }

    public Object getDatakey() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.datakey), null);
    }

    public void setDatakey(Object _datakey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.datakey), _datakey);
    }

    public boolean isAnimate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.animate), (Object)false);
    }

    public void setAnimate(boolean _animate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.animate), (Object)_animate);
    }

    public String getOrientation() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.orientation), (Object)"vertical");
    }

    public void setOrientation(String _orientation) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.orientation), (Object)_orientation);
    }

    public boolean isPropagateSelectionUp() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.propagateSelectionUp), (Object)true);
    }

    public void setPropagateSelectionUp(boolean _propagateSelectionUp) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.propagateSelectionUp), (Object)_propagateSelectionUp);
    }

    public boolean isPropagateSelectionDown() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.propagateSelectionDown), (Object)true);
    }

    public void setPropagateSelectionDown(boolean _propagateSelectionDown) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.propagateSelectionDown), (Object)_propagateSelectionDown);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir), (Object)"ltr");
    }

    public void setDir(String _dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), (Object)_dir);
    }

    public boolean isDraggable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggable), (Object)false);
    }

    public void setDraggable(boolean _draggable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggable), (Object)_draggable);
    }

    public boolean isDroppable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.droppable), (Object)false);
    }

    public void setDroppable(boolean _droppable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.droppable), (Object)_droppable);
    }

    public String getDragdropScope() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dragdropScope), null);
    }

    public void setDragdropScope(String _dragdropScope) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dragdropScope), (Object)_dragdropScope);
    }

    public String getDragMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dragMode), (Object)"self");
    }

    public void setDragMode(String _dragMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dragMode), (Object)_dragMode);
    }

    public String getDropRestrict() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dropRestrict), (Object)"none");
    }

    public void setDropRestrict(String _dropRestrict) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dropRestrict), (Object)_dropRestrict);
    }

    public UITreeNode getUITreeNodeByType(String type) {
        UITreeNode node = this.getTreeNodes().get(type);
        if (node == null) {
            throw new FacesException("Unsupported tree node type:" + type);
        }
        return node;
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public boolean isNodeExpandRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_expandNode");
    }

    public boolean isSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelection");
    }

    public Map<String, UITreeNode> getTreeNodes() {
        if (this.nodes == null) {
            this.nodes = new HashMap<String, UITreeNode>();
            for (UIComponent child : this.getChildren()) {
                UITreeNode node = (UITreeNode)child;
                this.nodes.put(node.getType(), node);
            }
        }
        return this.nodes;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("expand")) {
                this.setRowKey((String)params.get(clientId + "_expandNode"));
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
            } else if (eventName.equals("collapse")) {
                this.setRowKey((String)params.get(clientId + "_collapseNode"));
                TreeNode collapsedNode = this.getRowNode();
                collapsedNode.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), collapsedNode);
            } else if (eventName.equals("select")) {
                this.setRowKey((String)params.get(clientId + "_instantSelection"));
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
            } else if (eventName.equals("unselect")) {
                this.setRowKey((String)params.get(clientId + "_instantUnselection"));
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
            } else if (eventName.equals("dragdrop")) {
                int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
                wrapperEvent = new TreeDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), this.dragNode, this.dropNode, dndIndex);
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
            this.setRowKey(null);
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expandNode") != null || params.get(clientId + "_collapseNode") != null;
    }

    public boolean isDragDropRequest(FacesContext context) {
        String source;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(context);
        return clientId.equals(source = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source")) && params.get(clientId + "_dragdrop") != null;
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (!this.isToggleRequest(context)) {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.updateSelection(context);
        } else {
            super.processUpdates(context);
        }
    }

    public boolean isCheckboxSelection() {
        String selectionMode = this.getSelectionMode();
        return selectionMode != null && selectionMode.equals("checkbox");
    }

    @Override
    public boolean isRTL() {
        return this.getDir().equalsIgnoreCase("rtl");
    }

    TreeNode getDragNode() {
        return this.dragNode;
    }

    void setDragNode(TreeNode dragNode) {
        this.dragNode = dragNode;
    }

    TreeNode getDropNode() {
        return this.dropNode;
    }

    void setDropNode(TreeNode dropNode) {
        this.dropNode = dropNode;
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        dynamic,
        cache,
        onNodeClick,
        style,
        styleClass,
        highlight,
        datakey,
        animate,
        orientation,
        propagateSelectionUp,
        propagateSelectionDown,
        dir,
        draggable,
        droppable,
        dragdropScope,
        dragMode,
        dropRestrict;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

