/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.DebugObjectOutputStream;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ClientSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ByteArrayGuard guard;
    private boolean stateTimeoutEnabled;
    private long stateTimeout;
    private int csBuffSize;
    private boolean debugSerializedState;

    public ClientSideStateHelper() {
        this.init();
    }

    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        if (stateCapture != null) {
            this.doWriteState(ctx, state, new StringBuilderWriter(stateCapture));
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", null);
            writer.writeAttribute("name", "javax.faces.ViewState", null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                String viewStateId = Util.getViewStateId(ctx);
                writer.writeAttribute("id", viewStateId, null);
            }
            StringBuilder stateBuilder = new StringBuilder();
            this.doWriteState(ctx, state, new StringBuilderWriter(stateBuilder));
            writer.writeAttribute("value", stateBuilder.toString(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", "off", null);
            }
            writer.endElement("input");
            this.writeClientWindowField(ctx, writer);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    public Object getState(FacesContext ctx, String viewId) throws IOException {
        String stateString = ClientSideStateHelper.getStateParamValue(ctx);
        if (stateString == null) {
            return null;
        }
        if ("stateless".equals(stateString)) {
            return "stateless";
        }
        return this.doGetState(stateString);
    }

    protected Object doGetState(String stateString) {
        if ("stateless".equals(stateString)) {
            return null;
        }
        ObjectInputStream ois = null;
        InputStream bis = new Base64InputStream(stateString);
        try {
            if (this.guard != null) {
                byte[] bytes = stateString.getBytes("UTF-8");
                int numRead = bis.read(bytes, 0, bytes.length);
                byte[] decodedBytes = new byte[numRead];
                bis.reset();
                bis.read(decodedBytes, 0, decodedBytes.length);
                bytes = this.guard.decrypt(decodedBytes);
                if (bytes == null) {
                    Object var7_15 = null;
                    return var7_15;
                }
                bis = new ByteArrayInputStream(bytes);
            }
            if (this.compressViewState) {
                bis = new GZIPInputStream(bis);
            }
            ois = this.serialProvider.createObjectInputStream(bis);
            long stateTime = 0L;
            if (this.stateTimeoutEnabled) {
                try {
                    stateTime = ois.readLong();
                }
                catch (IOException ioe) {
                    Object var7_16;
                    block38: {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                        }
                        var7_16 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException ioe2) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block38;
                                LOGGER.log(Level.FINEST, "Closing stream", ioe2);
                            }
                        }
                    }
                    return var7_16;
                }
            }
            Object structure = ois.readObject();
            Object state = ois.readObject();
            if (stateTime != 0L && this.hasStateExpired(stateTime)) {
                Object var8_20 = null;
                return var8_20;
            }
            Object[] objectArray = new Object[]{structure, state};
            return objectArray;
        }
        catch (OptionalDataException ode) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ode.getMessage(), ode);
            }
            throw new FacesException(ode);
        }
        catch (ClassNotFoundException cnfe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, cnfe.getMessage(), cnfe);
            }
            throw new FacesException(cnfe);
        }
        catch (InvalidClassException ice) {
            Object var5_11 = null;
            return var5_11;
        }
        catch (IOException iox) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iox.getMessage(), iox);
            }
            throw new FacesException(iox);
        }
        finally {
            block39: {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block39;
                        LOGGER.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteState(FacesContext facesContext, Object state, Writer writer) throws IOException {
        if (facesContext.getViewRoot().isTransient()) {
            writer.write("stateless");
            writer.flush();
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream base = null;
        base = this.compressViewState ? new GZIPOutputStream((OutputStream)baos, this.csBuffSize) : baos;
        ObjectOutputStream oos = null;
        try {
            DebugObjectOutputStream out;
            ByteArrayOutputStream discard;
            oos = this.serialProvider.createObjectOutputStream(new BufferedOutputStream(base));
            if (this.stateTimeoutEnabled) {
                oos.writeLong(System.currentTimeMillis());
            }
            Object[] stateToWrite = (Object[])state;
            if (this.debugSerializedState) {
                discard = new ByteArrayOutputStream();
                out = new DebugObjectOutputStream(discard);
                try {
                    out.writeObject(stateToWrite[0]);
                }
                catch (Exception e) {
                    throw new FacesException("Serialization error. Path to offending instance: " + out.getStack(), e);
                }
            }
            oos.writeObject(stateToWrite[0]);
            if (this.debugSerializedState) {
                discard = new ByteArrayOutputStream();
                out = new DebugObjectOutputStream(discard);
                try {
                    out.writeObject(stateToWrite[1]);
                }
                catch (Exception e) {
                    DebugUtil.printState((Map)stateToWrite[1], LOGGER);
                    throw new FacesException("Serialization error. Path to offending instance: " + out.getStack(), e);
                }
            }
            oos.writeObject(stateToWrite[1]);
            oos.flush();
            oos.close();
            oos = null;
            byte[] bytes = baos.toByteArray();
            if (this.guard != null) {
                bytes = this.guard.encrypt(bytes);
            }
            Base64OutputStreamWriter bos = new Base64OutputStreamWriter(bytes.length, writer);
            bos.write(bytes, 0, bytes.length);
            bos.finish();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client State: total number of characters written: {0}", bos.getTotalCharsWritten());
            }
        }
        finally {
            block19: {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                        LOGGER.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
            }
        }
    }

    protected boolean hasStateExpired(long stateTime) {
        if (this.stateTimeoutEnabled) {
            long elapsed = (System.currentTimeMillis() - stateTime) / 60000L;
            return elapsed > this.stateTimeout;
        }
        return false;
    }

    protected void init() {
        if (!this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.DisableClientStateEncryption)) {
            this.guard = new ByteArrayGuard();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.config.webconfig.enventry.clientencrypt");
        }
        this.stateTimeoutEnabled = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
        if (this.stateTimeoutEnabled) {
            String timeout = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
            try {
                this.stateTimeout = Long.parseLong(timeout);
            }
            catch (NumberFormatException nfe) {
                this.stateTimeout = Long.parseLong(WebConfiguration.WebContextInitParameter.ClientStateTimeout.getDefaultValue());
            }
        }
        String size = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String defaultSize = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(size);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
                }
                this.csBuffSize = Integer.parseInt(defaultSize);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
            }
            this.csBuffSize = Integer.parseInt(defaultSize);
        }
        this.debugSerializedState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableClientStateDebugging);
    }

    public boolean isStateless(FacesContext facesContext, String viewId) throws IllegalStateException {
        if (facesContext.isPostback()) {
            Object stateObject;
            try {
                stateObject = this.getState(facesContext, viewId);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Cannot determine whether or not the request is stateless", ioe);
            }
            return stateObject instanceof String && "stateless".equals((String)stateObject);
        }
        throw new IllegalStateException("Cannot determine whether or not the request is stateless");
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private StringBuilder sb;

        protected StringBuilderWriter(StringBuilder sb) {
            this.sb = sb;
        }

        public void write(int c) throws IOException {
            this.sb.append((char)c);
        }

        public void write(char[] cbuf) throws IOException {
            this.sb.append(cbuf);
        }

        public void write(String str) throws IOException {
            this.sb.append(str);
        }

        public void write(String str, int off, int len) throws IOException {
            this.sb.append(str.toCharArray(), off, len);
        }

        public Writer append(CharSequence csq) throws IOException {
            this.sb.append(csq);
            return this;
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.sb.append(csq, start, end);
            return this;
        }

        public Writer append(char c) throws IOException {
            this.sb.append(c);
            return this;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

