/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.facesviews.ViewHandlerMode;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.ResourcePaths;

public class FacesViewsViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler wrapped;

    public FacesViewsViewHandler(ViewHandler viewHandler) {
        this.wrapped = viewHandler;
    }

    public String getActionURL(FacesContext context, String viewId) {
        String actionURL = super.getActionURL(context, viewId);
        Map mappedResources = (Map)FacesLocal.getApplicationAttribute(context, "org.omnifaces.facesviews");
        if (mappedResources.containsKey(viewId) && (FacesViews.isScannedViewsAlwaysExtensionless(context).booleanValue() || this.isOriginalViewExtensionless(context))) {
            ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
            if (servletContext.getMajorVersion() > 2 && FacesViews.getViewHandlerMode(servletContext) == ViewHandlerMode.STRIP_EXTENSION_FROM_PARENT) {
                return this.removeExtension(context, actionURL, viewId);
            }
            return context.getExternalContext().getRequestContextPath() + ResourcePaths.stripExtension(viewId) + FacesViewsViewHandler.getQueryParameters(actionURL);
        }
        return actionURL;
    }

    private boolean isOriginalViewExtensionless(FacesContext context) {
        String originalViewId = (String)FacesLocal.getRequestAttribute(context, "javax.servlet.forward.servlet_path");
        if (originalViewId == null) {
            originalViewId = (String)FacesLocal.getRequestAttribute(context, "org.omnifaces.facesviews.original.servlet_path");
        }
        return ResourcePaths.isExtensionless(originalViewId);
    }

    public String removeExtension(FacesContext context, String resource, String viewId) {
        String viewIdExtension;
        Set<String> extensions = FacesViews.getFacesServletExtensions(context);
        if (!ResourcePaths.isExtensionless(viewId) && !extensions.contains(viewIdExtension = ResourcePaths.getExtension(viewId))) {
            extensions = new HashSet<String>(extensions);
            extensions.add(viewIdExtension);
        }
        int lastSlashPos = resource.lastIndexOf(47);
        int lastQuestionMarkPos = resource.lastIndexOf(63);
        for (String extension : extensions) {
            int extensionPos = resource.lastIndexOf(extension);
            if (extensionPos <= lastSlashPos || lastQuestionMarkPos != -1 && extensionPos >= lastQuestionMarkPos) continue;
            return resource.substring(0, extensionPos) + resource.substring(extensionPos + extension.length());
        }
        return resource;
    }

    public static String getQueryParameters(String resource) {
        String queryParameters = "";
        int questionMarkPos = resource.indexOf(63);
        if (questionMarkPos != -1) {
            queryParameters = resource.substring(questionMarkPos);
        }
        return queryParameters;
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }
}

