/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import org.omnifaces.config.WebXml;
import org.omnifaces.eventlistener.DefaultServletContextListener;
import org.omnifaces.facesviews.FacesServletDispatchMethod;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

@WebListener
public class FacesViewsInitializerListener
extends DefaultServletContextListener {
    @Override
    public void contextInitialized(ServletContextEvent context) {
        Set extensions;
        ServletContext servletContext = context.getServletContext();
        if (!"false".equals(servletContext.getInitParameter("org.omnifaces.FACES_VIEWS_ENABLED")) && !Utils.isEmpty(extensions = (Set)Servlets.getApplicationAttribute(servletContext, "org.omnifaces.facesviews.extensions"))) {
            HashSet<String> mappings = new HashSet<String>(extensions);
            for (String welcomeFile : WebXml.INSTANCE.init(servletContext).getWelcomeFiles()) {
                if (!ResourcePaths.isExtensionless(welcomeFile)) continue;
                if (!welcomeFile.startsWith("/")) {
                    welcomeFile = "/" + welcomeFile;
                }
                mappings.add(welcomeFile);
            }
            if (FacesViews.getFacesServletDispatchMethod(servletContext) == FacesServletDispatchMethod.DO_FILTER) {
                Map collectedViews = (Map)Servlets.getApplicationAttribute(servletContext, "org.omnifaces.facesviews");
                mappings.addAll(ResourcePaths.filterExtension(collectedViews.keySet()));
            }
            FacesViews.mapFacesServlet(servletContext, mappings);
        }
    }
}

