/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.HashSet;
import java.util.Set;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.omnifaces.util.Faces;

public class CallbackPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 3611407485061585042L;

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        Set<PhaseListener> phaseListeners = CallbackPhaseListener.getCallbackPhaseListeners(false);
        if (phaseListeners == null) {
            return;
        }
        for (PhaseListener phaseListener : phaseListeners) {
            if (!CallbackPhaseListener.isPhaseMatch(event, phaseListener.getPhaseId())) continue;
            phaseListener.beforePhase(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        Set<PhaseListener> phaseListeners = CallbackPhaseListener.getCallbackPhaseListeners(false);
        if (phaseListeners == null) {
            return;
        }
        for (PhaseListener phaseListener : phaseListeners) {
            if (!CallbackPhaseListener.isPhaseMatch(event, phaseListener.getPhaseId())) continue;
            phaseListener.afterPhase(event);
        }
    }

    public static void add(PhaseListener phaseListener) {
        CallbackPhaseListener.getCallbackPhaseListeners(true).add(phaseListener);
    }

    public static boolean remove(PhaseListener phaseListener) {
        Set<PhaseListener> phaseListeners = CallbackPhaseListener.getCallbackPhaseListeners(false);
        return phaseListeners == null ? false : phaseListeners.remove(phaseListener);
    }

    private static Set<PhaseListener> getCallbackPhaseListeners(boolean create) {
        HashSet set = (HashSet)Faces.getRequestAttribute(CallbackPhaseListener.class.getName());
        if (set == null && create) {
            set = new HashSet(1);
            Faces.setRequestAttribute(CallbackPhaseListener.class.getName(), set);
        }
        return set;
    }

    private static boolean isPhaseMatch(PhaseEvent event, PhaseId phaseId) {
        return PhaseId.ANY_PHASE.equals(phaseId) || event.getPhaseId().equals(phaseId);
    }
}

