/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component;

import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public final class EditableValueHolderStateHelper {
    private Object submittedValue;
    private boolean valid = true;
    private Object localValue;
    private boolean localValueSet;

    public void save(EditableValueHolder holder) {
        this.submittedValue = holder.getSubmittedValue();
        this.valid = holder.isValid();
        this.localValue = holder.getLocalValue();
        this.localValueSet = holder.isLocalValueSet();
    }

    public void restore(EditableValueHolder holder) {
        holder.setSubmittedValue(this.submittedValue);
        holder.setValid(this.valid);
        holder.setValue(this.localValue);
        holder.setLocalValueSet(this.localValueSet);
    }

    public static void save(FacesContext context, StateHelper stateHelper, Iterator<UIComponent> children) {
        while (children.hasNext()) {
            UIComponent child = children.next();
            if (child instanceof EditableValueHolder && !child.isTransient()) {
                EditableValueHolderStateHelper.get(stateHelper, child.getClientId(context)).save((EditableValueHolder)child);
            }
            if (child.getFacetCount() <= 0 && child.getChildCount() <= 0) continue;
            EditableValueHolderStateHelper.save(context, stateHelper, child.getFacetsAndChildren());
        }
    }

    public static void restore(FacesContext context, StateHelper stateHelper, Iterator<UIComponent> children) {
        while (children.hasNext()) {
            UIComponent child = children.next();
            child.setId(child.getId());
            if (child instanceof EditableValueHolder && !child.isTransient()) {
                EditableValueHolderStateHelper.get(stateHelper, child.getClientId(context)).restore((EditableValueHolder)child);
            }
            if (child.getFacetCount() <= 0 && child.getChildCount() <= 0) continue;
            EditableValueHolderStateHelper.restore(context, stateHelper, child.getFacetsAndChildren());
        }
    }

    public static EditableValueHolderStateHelper get(StateHelper stateHelper, String clientId) {
        Map childState = (Map)stateHelper.get(EditableValueHolderStateHelper.class);
        EditableValueHolderStateHelper state = null;
        if (childState != null) {
            state = (EditableValueHolderStateHelper)childState.get(clientId);
        }
        if (state == null) {
            state = new EditableValueHolderStateHelper();
            stateHelper.put(EditableValueHolderStateHelper.class, clientId, (Object)state);
        }
        return state;
    }
}

