/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.viewhandler;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.omnifaces.taghandler.EnableRestorableView;
import org.omnifaces.util.Faces;

public class RestorableViewHandler
extends ViewHandlerWrapper {
    private ViewHandler wrapped;

    public RestorableViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        UIViewRoot restoredView = super.restoreView(context, viewId);
        if (restoredView != null || !context.isPostback()) {
            return restoredView;
        }
        viewId = Faces.normalizeViewId(viewId);
        UIViewRoot createdView = this.createView(context, viewId);
        TemporaryViewFacesContext temporaryContext = new TemporaryViewFacesContext(context, createdView);
        try {
            Faces.setContext((FacesContext)temporaryContext);
            this.getViewDeclarationLanguage((FacesContext)temporaryContext, viewId).buildView((FacesContext)temporaryContext, createdView);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            Faces.setContext(context);
        }
        if (createdView.getAttributes().get(EnableRestorableView.class.getName()) == Boolean.TRUE) {
            return createdView;
        }
        return null;
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    private static class TemporaryViewFacesContext
    extends FacesContextWrapper {
        private FacesContext wrapped;
        private UIViewRoot temporaryView;

        public TemporaryViewFacesContext(FacesContext wrapped, UIViewRoot temporaryView) {
            this.wrapped = wrapped;
            this.temporaryView = temporaryView;
        }

        public UIViewRoot getViewRoot() {
            return this.temporaryView;
        }

        public RenderKit getRenderKit() {
            return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit((FacesContext)this, this.temporaryView.getRenderKitId());
        }

        public FacesContext getWrapped() {
            return this.wrapped;
        }
    }
}

