/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.omnifaces.util.Utils;

public final class Beans {
    public static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass) {
        Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
        if (Utils.isEmpty(beans)) {
            return null;
        }
        return beanManager.resolve(beans);
    }

    public static <T> T getReference(BeanManager beanManager, Class<T> beanClass) {
        return Beans.getReference(beanManager, Beans.resolve(beanManager, beanClass));
    }

    public static <T> T getReference(BeanManager beanManager, Bean<T> bean) {
        return (T)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean));
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass, boolean create) {
        return Beans.getInstance(beanManager, Beans.resolve(beanManager, beanClass), create);
    }

    public static <T> T getInstance(BeanManager beanManager, Bean<T> bean, boolean create) {
        Context context = beanManager.getContext(bean.getScope());
        if (create) {
            return (T)context.get(bean, beanManager.createCreationalContext(bean));
        }
        return (T)context.get(bean);
    }

    public static Map<Object, String> getActiveInstances(BeanManager beanManager, Class<? extends Annotation> scope) {
        HashMap<Object, String> activeInstances = new HashMap<Object, String>();
        Set beans = beanManager.getBeans(Object.class, new Annotation[0]);
        Context context = beanManager.getContext(scope);
        for (Bean bean : beans) {
            Object instance = context.get((Contextual)bean);
            if (instance == null) continue;
            activeInstances.put(instance, bean.getName());
        }
        return Collections.unmodifiableMap(activeInstances);
    }
}

