/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.DelegatingMetaTagHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.faces.view.facelets.ValidatorConfig;
import javax.faces.view.facelets.ValidatorHandler;
import org.omnifaces.taghandler.RenderTimeTagHandlerHelper;
import org.omnifaces.util.Components;
import org.omnifaces.util.Messages;

public class Validator
extends ValidatorHandler
implements RenderTimeTagHandlerHelper.RenderTimeTagHandler {
    public Validator(ValidatorConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent) && UIComponent.getCompositeComponentParent((UIComponent)parent) == null) {
            return;
        }
        if (!(parent instanceof EditableValueHolder)) {
            super.apply(context, parent);
            return;
        }
        final javax.faces.validator.Validator validator = (javax.faces.validator.Validator)RenderTimeTagHandlerHelper.createInstance(context, this, "validatorId");
        final RenderTimeTagHandlerHelper.RenderTimeAttributes attributes = RenderTimeTagHandlerHelper.collectRenderTimeAttributes(context, this, validator);
        final ValueExpression disabled = RenderTimeTagHandlerHelper.getValueExpression(context, this, "disabled", Boolean.class);
        final ValueExpression message = RenderTimeTagHandlerHelper.getValueExpression(context, this, "message", String.class);
        ((EditableValueHolder)parent).addValidator((javax.faces.validator.Validator)new RenderTimeValidator(){
            private static final long serialVersionUID = 1L;

            public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
                ELContext el = context.getELContext();
                if (disabled == null || Boolean.FALSE.equals(disabled.getValue(el))) {
                    attributes.invokeSetters(el, validator);
                    try {
                        validator.validate(context, component, value);
                    }
                    catch (ValidatorException e) {
                        String validatorMessage;
                        if (message != null && (validatorMessage = (String)message.getValue(el)) != null) {
                            String label = Components.getLabel(component);
                            throw new ValidatorException(Messages.create(validatorMessage, label).detail(validatorMessage, label).error().get(), e.getCause());
                        }
                        throw e;
                    }
                }
            }
        });
    }

    @Override
    public <T> T create(Application application, String id) {
        return (T)application.createValidator(id);
    }

    @Override
    public TagAttribute getTagAttribute(String name) {
        return this.getAttribute(name);
    }

    protected TagHandlerDelegate getTagHandlerDelegate() {
        return new RenderTimeTagHandlerHelper.RenderTimeTagHandlerDelegate((DelegatingMetaTagHandler)this, super.getTagHandlerDelegate());
    }

    public boolean isDisabled(FaceletContext context) {
        return false;
    }

    protected static abstract class RenderTimeValidator
    implements javax.faces.validator.Validator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected RenderTimeValidator() {
        }
    }
}

