/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omnifaces.util.JNDI;

public enum BeanManager {
    INSTANCE;

    private static final Logger logger;
    private static final String LOG_INITIALIZATION_ERROR = "BeanManager enum singleton failed to initialize.";
    private static final Annotation[] NO_ANNOTATIONS;
    private AtomicBoolean initialized = new AtomicBoolean();
    private Object beanManager;
    private Method getBeans;
    private Method resolve;
    private Method createCreationalContext;
    private Method getReference;

    private void init() {
        if (!this.initialized.getAndSet(true)) {
            try {
                Class.forName("javax.enterprise.inject.spi.BeanManager");
                Class.forName("javax.naming.InitialContext");
            }
            catch (Exception e) {
                return;
            }
            try {
                Object beanManager = JNDI.lookup("java:comp/BeanManager");
                if (beanManager == null) {
                    beanManager = JNDI.lookup("java:comp/env/BeanManager");
                }
                if (beanManager == null) {
                    return;
                }
                this.beanManager = beanManager;
                Class<?> beanManagerClass = beanManager.getClass();
                Class<?> contextualClass = Class.forName("javax.enterprise.context.spi.Contextual");
                Class<?> beanClass = Class.forName("javax.enterprise.inject.spi.Bean");
                Class<?> creationalContextClass = Class.forName("javax.enterprise.context.spi.CreationalContext");
                this.getBeans = beanManagerClass.getMethod("getBeans", Type.class, Annotation[].class);
                this.resolve = beanManagerClass.getMethod("resolve", Set.class);
                this.createCreationalContext = beanManagerClass.getMethod("createCreationalContext", contextualClass);
                this.getReference = beanManagerClass.getMethod("getReference", beanClass, Type.class, creationalContextClass);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, LOG_INITIALIZATION_ERROR, e);
                throw new RuntimeException(e);
            }
        }
    }

    public <T> T getReference(Class<T> beanClass) {
        this.init();
        if (this.beanManager == null) {
            return null;
        }
        try {
            Object bean = this.resolve.invoke(this.beanManager, this.getBeans.invoke(this.beanManager, beanClass, NO_ANNOTATIONS));
            Object creationalContext = this.createCreationalContext.invoke(this.beanManager, bean);
            Object reference = this.getReference.invoke(this.beanManager, bean, beanClass, creationalContext);
            return beanClass.cast(reference);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        logger = Logger.getLogger(BeanManager.class.getName());
        NO_ANNOTATIONS = new Annotation[0];
    }
}

