/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.util.Utils;

public final class Servlets {
    private Servlets() {
    }

    public static String getRequestHostname(HttpServletRequest request) {
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getRequestDomainURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.length() - request.getRequestURI().length());
    }

    public static String getRequestBaseURL(HttpServletRequest request) {
        return Servlets.getRequestDomainURL(request) + request.getContextPath() + "/";
    }

    public static String getRequestURLWithQueryString(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        return queryString == null ? requestURL.toString() : requestURL.append('?').append(queryString).toString();
    }

    public static String getRequestURIWithQueryString(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public static Map<String, List<String>> getRequestQueryStringMap(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (Utils.isEmpty(queryString)) {
            return Collections.emptyMap();
        }
        return Servlets.toParameterMap(queryString);
    }

    public static Map<String, List<String>> toParameterMap(String queryString) {
        String[] parameters = queryString.split(Pattern.quote("&"));
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(parameters.length);
        for (String parameter : parameters) {
            if (!parameter.contains("=")) continue;
            String[] pair = parameter.split(Pattern.quote("="));
            String key = Utils.decodeURL(pair[0]);
            String value = pair.length > 1 && !Utils.isEmpty(pair[1]) ? Utils.decodeURL(pair[1]) : "";
            ArrayList<String> values = (ArrayList<String>)parameterMap.get(key);
            if (values == null) {
                values = new ArrayList<String>(1);
                parameterMap.put(key, values);
            }
            values.add(value);
        }
        return parameterMap;
    }

    public static <T> T getApplicationAttribute(ServletContext context, String name) {
        return (T)context.getAttribute(name);
    }
}

