/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;

public class BeanStorage
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final ConcurrentMap<String, Bean<?>> beans;

    public BeanStorage(int initialCapacity) {
        this.beans = new ConcurrentHashMap(initialCapacity);
    }

    public <T> T createBean(Contextual<T> type, CreationalContext<T> context) {
        Bean<T> bean = new Bean<T>(type, context);
        this.beans.put(((PassivationCapable)type).getId(), bean);
        return bean.getInstance();
    }

    public <T> T getBean(Contextual<T> type, BeanManager manager) {
        Bean bean = (Bean)this.beans.get(((PassivationCapable)type).getId());
        if (bean == null) {
            return null;
        }
        if (!bean.hasContext()) {
            bean.setContext(type, manager.createCreationalContext(type));
        }
        return bean.getInstance();
    }

    public synchronized void destroyBeans() {
        for (Bean bean : this.beans.values()) {
            bean.destroy();
        }
        this.beans.clear();
    }

    static class Bean<T>
    implements Serializable {
        private static final long serialVersionUID = 42L;
        private transient Contextual<T> type;
        private transient CreationalContext<T> context;
        private final T instance;

        public Bean(Contextual<T> type, CreationalContext<T> context) {
            this.setContext(type, context);
            this.instance = type.create(context);
        }

        public void setContext(Contextual<T> type, CreationalContext<T> context) {
            this.type = type;
            this.context = context;
        }

        public boolean hasContext() {
            return this.type != null && this.context != null;
        }

        public T getInstance() {
            return this.instance;
        }

        public void destroy() {
            if (this.hasContext()) {
                this.type.destroy(this.instance, this.context);
            }
        }
    }
}

