/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.paginator;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIData;
import org.primefaces.component.paginator.PaginatorElementRenderer;

public class PageLinksRenderer
implements PaginatorElementRenderer {
    public void render(FacesContext context, UIData uidata) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int currentPage = uidata.getPage();
        int pageLinks = uidata.getPageLinks();
        int pageCount = uidata.getPageCount();
        int visiblePages = Math.min(pageLinks, pageCount);
        int start = Math.max(0, (int)Math.ceil(currentPage - visiblePages / 2));
        int end = Math.min(pageCount - 1, start + visiblePages - 1);
        int delta = pageLinks - (end - start + 1);
        start = Math.max(0, start - delta);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-paginator-pages", null);
        for (int i = start; i <= end; ++i) {
            String styleClass = currentPage == i ? "ui-paginator-page ui-state-default ui-state-active ui-corner-all" : "ui-paginator-page ui-state-default ui-corner-all";
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.writeText((Object)(i + 1), null);
            writer.endElement("span");
        }
        writer.endElement("span");
    }
}

