/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.behavior.ajax;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;

public class AjaxBehaviorListenerImpl
implements AjaxBehaviorListener,
Serializable {
    private static Logger LOG = Logger.getLogger(AjaxBehaviorListenerImpl.class.getName());
    private MethodExpression listener;
    private MethodExpression listenerWithArg;

    public AjaxBehaviorListenerImpl() {
    }

    public AjaxBehaviorListenerImpl(MethodExpression listener, MethodExpression listenerWithArg) {
        this.listener = listener;
        this.listenerWithArg = listenerWithArg;
    }

    public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Try to invoke listener: " + this.listener.getExpressionString());
        }
        try {
            this.listener.invoke(elContext, new Object[0]);
        }
        catch (MethodNotFoundException mnfe) {
            this.processArgListener(context, elContext, event);
        }
        catch (IllegalArgumentException iae) {
            this.processArgListener(context, elContext, event);
        }
    }

    private void processArgListener(FacesContext context, ELContext elContext, AjaxBehaviorEvent event) throws AbortProcessingException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Try to invoke listenerWithArg: " + this.listenerWithArg.getExpressionString());
        }
        try {
            this.listenerWithArg.invoke(elContext, new Object[]{event});
        }
        catch (MethodNotFoundException mnfe) {
            this.processCustomListener(context, elContext, event);
        }
        catch (IllegalArgumentException e) {
            this.processCustomListener(context, elContext, event);
        }
    }

    private void processCustomListener(FacesContext context, ELContext elContext, AjaxBehaviorEvent event) throws AbortProcessingException {
        MethodExpression argListener = context.getApplication().getExpressionFactory().createMethodExpression(elContext, this.listener.getExpressionString(), null, new Class[]{event.getClass()});
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Try to invoke customListener: " + argListener.getExpressionString());
        }
        argListener.invoke(elContext, new Object[]{event});
    }
}

