/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.omnifaces.el.functions.Converters;
import org.omnifaces.resourcehandler.CombinedResourceHandler;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

final class CombinedResourceInfo {
    private static final Logger logger = Logger.getLogger(CombinedResourceHandler.class.getName());
    private static final Map<String, CombinedResourceInfo> CACHE = new HashMap<String, CombinedResourceInfo>();
    private static final String MOJARRA_DEFAULT_RESOURCE_MAX_AGE = "com.sun.faces.defaultResourceMaxAge";
    private static final String MYFACES_DEFAULT_RESOURCE_MAX_AGE = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final long DEFAULT_RESOURCE_MAX_AGE = 604800000L;
    private static final String[] PARAM_NAMES_RESOURCE_MAX_AGE = new String[]{"com.sun.faces.defaultResourceMaxAge", "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES"};
    private static final String LOG_RESOURCE_NOT_FOUND = "CombinedResourceHandler: The resource %s cannot be found and therefore a 404 will be returned for the combined resource ID %s";
    private static Long maxAge;
    private String id;
    private Set<ResourceIdentifier> resourceIdentifiers;
    private Set<Resource> resources;
    private int contentLength;
    private long lastModified;

    private CombinedResourceInfo(String id, Set<ResourceIdentifier> resourceIdentifiers) {
        this.id = id;
        this.resourceIdentifiers = resourceIdentifiers;
    }

    public static CombinedResourceInfo get(String id) {
        Set<ResourceIdentifier> resourceIdentifiers;
        CombinedResourceInfo info = CACHE.get(id);
        if (info == null && (resourceIdentifiers = CombinedResourceInfo.fromUniqueId(id)) != null) {
            info = new CombinedResourceInfo(id, Collections.unmodifiableSet(resourceIdentifiers));
            CACHE.put(id, info);
        }
        return info;
    }

    private synchronized void loadResources() {
        if (!Utils.isEmpty(this.resources)) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ResourceHandler handler = context.getApplication().getResourceHandler();
        this.resources = new LinkedHashSet<Resource>();
        this.contentLength = 0;
        this.lastModified = 0L;
        for (ResourceIdentifier resourceIdentifier : this.resourceIdentifiers) {
            Resource resource = handler.createResource(resourceIdentifier.getName(), resourceIdentifier.getLibrary());
            if (resource == null) {
                logger.log(Level.WARNING, String.format(LOG_RESOURCE_NOT_FOUND, resourceIdentifier, this.id));
                this.resources.clear();
                return;
            }
            this.resources.add(resource);
            try {
                URLConnection connection = !Hacks.isRichFacesResourceOptimizationEnabled() ? resource.getURL().openConnection() : new URL(Faces.getRequestDomainURL() + resource.getRequestPath()).openConnection();
                this.contentLength += connection.getContentLength();
                long lastModified = connection.getLastModified();
                if (lastModified <= this.lastModified) continue;
                this.lastModified = lastModified;
            }
            catch (IOException e) {}
        }
    }

    public boolean equals(Object other) {
        return other instanceof CombinedResourceInfo ? ((CombinedResourceInfo)other).id.equals(this.id) : false;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.id.hashCode();
    }

    public String toString() {
        return String.format("CombinedResourceInfo[%s,%s]", this.id, this.resourceIdentifiers);
    }

    public Set<ResourceIdentifier> getResourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public Set<Resource> getResources() {
        this.loadResources();
        return this.resources;
    }

    public int getContentLength() {
        this.loadResources();
        return this.contentLength;
    }

    public long getLastModified() {
        this.loadResources();
        return this.lastModified;
    }

    public long getMaxAge() {
        if (maxAge != null) {
            return maxAge;
        }
        for (String name : PARAM_NAMES_RESOURCE_MAX_AGE) {
            String value = Faces.getInitParameter(name);
            if (value == null || !value.matches("[0-9]+")) continue;
            maxAge = Long.valueOf(value);
            return maxAge;
        }
        maxAge = 604800000L;
        return maxAge;
    }

    private static String toUniqueId(Set<ResourceIdentifier> resourceIdentifiers) {
        return Utils.serializeURLSafe(Converters.joinCollection(resourceIdentifiers, "|"));
    }

    private static Set<ResourceIdentifier> fromUniqueId(String id) {
        String resourcesId;
        try {
            resourcesId = Utils.unserializeURLSafe(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        LinkedHashSet<ResourceIdentifier> resourceIdentifiers = new LinkedHashSet<ResourceIdentifier>();
        for (String resourceIdentifier : resourcesId.split("\\|")) {
            resourceIdentifiers.add(new ResourceIdentifier(resourceIdentifier));
        }
        return resourceIdentifiers;
    }

    public static final class Builder {
        private static final String ERROR_EMPTY_RESOURCES = "There are no resources been added. Use add() method to add them or use isEmpty() to check beforehand.";
        private Set<ResourceIdentifier> resourceIdentifiers = new LinkedHashSet<ResourceIdentifier>();

        public Builder add(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifiers.add(resourceIdentifier);
            return this;
        }

        public boolean isEmpty() {
            return this.resourceIdentifiers.isEmpty();
        }

        public String create() {
            if (this.resourceIdentifiers.isEmpty()) {
                throw new IllegalStateException(ERROR_EMPTY_RESOURCES);
            }
            return CombinedResourceInfo.get(CombinedResourceInfo.toUniqueId(this.resourceIdentifiers)).id;
        }
    }
}

