/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.filter.HttpFilter;

public class CharacterEncodingFilter
extends HttpFilter {
    private static final String INIT_PARAM_ENCODING = "encoding";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ERROR_ENCODING = "The 'encoding' init param must represent a valid charset. Encountered an invalid charset of '%s'.";
    private String encoding = "UTF-8";

    @Override
    public void init() throws ServletException {
        String encoding = this.getInitParameter(INIT_PARAM_ENCODING);
        if (encoding != null) {
            try {
                Charset.forName(encoding);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(ERROR_ENCODING, encoding), e);
            }
            this.encoding = encoding;
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.encoding);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

