/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.omnifaces.el.ELContextWrapper;
import org.omnifaces.el.ELResolverWrapper;
import org.omnifaces.el.ExpressionInspector;

public class MethodExpressionValueExpressionAdapter
extends MethodExpression {
    private static final long serialVersionUID = 1L;
    private final ValueExpression valueExpression;

    public MethodExpressionValueExpressionAdapter(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    public Object invoke(ELContext context, Object[] params) {
        try {
            return this.valueExpression.getValue((ELContext)new ValueToInvokeElContext(context, params));
        }
        catch (ELException e) {
            for (Throwable throwable = e.getCause(); throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof MethodNotFoundException)) continue;
                throw (MethodNotFoundException)throwable;
            }
            throw e;
        }
    }

    public MethodInfo getMethodInfo(ELContext context) {
        Method method = ExpressionInspector.getMethodReference(context, this.valueExpression).getMethod();
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])method.getParameterTypes());
    }

    public boolean isLiteralText() {
        return false;
    }

    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    public String getExpressionString() {
        return this.valueExpression.getExpressionString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodExpressionValueExpressionAdapter) {
            return ((MethodExpressionValueExpressionAdapter)((Object)obj)).getValueExpression().equals((Object)this.valueExpression);
        }
        return false;
    }

    public ValueExpression getValueExpression() {
        return this.valueExpression;
    }

    static class ValueToInvokeElResolver
    extends ELResolverWrapper {
        private static final Object[] EMPTY_PARAMETERS = new Object[0];
        private final Object[] callerProvidedParameters;

        public ValueToInvokeElResolver(ELResolver elResolver, Object[] callerProvidedParameters) {
            super(elResolver);
            this.callerProvidedParameters = callerProvidedParameters;
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            if (base == null) {
                return super.getValue(context, base, property);
            }
            try {
                return super.getValue(context, base, property);
            }
            catch (PropertyNotFoundException pnfe) {
                try {
                    return super.invoke(context, base, property, null, this.callerProvidedParameters != null ? this.callerProvidedParameters : EMPTY_PARAMETERS);
                }
                catch (MethodNotFoundException e) {
                    throw new ELException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    static class ValueToInvokeElContext
    extends ELContextWrapper {
        private final Object[] callerProvidedParameters;

        public ValueToInvokeElContext(ELContext elContext, Object[] callerProvidedParameters) {
            super(elContext);
            this.callerProvidedParameters = callerProvidedParameters;
        }

        @Override
        public ELResolver getELResolver() {
            return new ValueToInvokeElResolver(super.getELResolver(), this.callerProvidedParameters);
        }
    }
}

