/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;
import org.omnifaces.component.output.cache.CacheFactory;
import org.omnifaces.component.output.cache.CacheProvider;
import org.omnifaces.filter.OnDemandResponseBufferFilter;
import org.omnifaces.util.Faces;

@WebListener
public class CacheInitializerListener
implements ServletContextListener {
    public static final String CACHE_PROVIDER_INIT_PARAM_NAME = "org.omnifaces.CACHE_PROVIDER";
    public static final String CACHE_INSTALL_BUFFER_FILTER = "org.omnifaces.CACHE_INSTALL_BUFFER_FILTER";
    public static final String CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX = "org.omnifaces.CACHE_SETTING_";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        CacheProvider cacheProvider = this.getCacheProvider(context);
        cacheProvider.setParameters(this.getCacheSetting(context));
        if (Boolean.TRUE.equals(Boolean.valueOf(context.getInitParameter(CACHE_INSTALL_BUFFER_FILTER)))) {
            ServletRegistration facesServletRegistration = Faces.getFacesServletRegistration(context);
            FilterRegistration.Dynamic bufferFilterRegistration = context.addFilter(OnDemandResponseBufferFilter.class.getName(), OnDemandResponseBufferFilter.class);
            bufferFilterRegistration.addMappingForServletNames(null, true, new String[]{facesServletRegistration.getName()});
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private CacheProvider getCacheProvider(ServletContext context) {
        CacheProvider cacheProvider = null;
        String cacheProviderName = context.getInitParameter(CACHE_PROVIDER_INIT_PARAM_NAME);
        if (cacheProviderName != null) {
            cacheProvider = this.createInstance(cacheProviderName);
            CacheFactory.setCacheProvider(cacheProvider, context);
        } else {
            cacheProvider = CacheFactory.getDefaultCacheProvider();
        }
        return cacheProvider;
    }

    private CacheProvider createInstance(String cacheProviderName) {
        try {
            return (CacheProvider)Class.forName(cacheProviderName).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, String> getCacheSetting(ServletContext context) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (String initParameterName : Collections.list(context.getInitParameterNames())) {
            if (!initParameterName.startsWith(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX)) continue;
            settings.put(initParameterName.substring(CACHE_PROVIDER_SETTING_INIT_PARAM_PREFIX.length()), context.getInitParameter(initParameterName));
        }
        return settings;
    }
}

