/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.event.system;

import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.component.column.Column;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;

public class DataTableExpressionAdapter
implements SystemEventListener {
    public void processEvent(SystemEvent event) throws AbortProcessingException {
        DataTable dt = (DataTable)event.getSource();
        if (!dt.isExpressionsAdapted()) {
            FacesContext context = FacesContext.getCurrentInstance();
            String var = dt.getVar();
            int columnsCount = dt.getChildCount();
            if (columnsCount > 0) {
                List children = dt.getChildren();
                for (int i = 0; i < columnsCount; ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (child instanceof Column) {
                        String sortByProperty = this.convertStaticExpression(var, child.getValueExpression("sortBy"));
                        String filterByProperty = this.convertStaticExpression(var, child.getValueExpression("filterBy"));
                        ValueExpression disabledSelectionVE = child.getValueExpression("disabledSelection");
                        if (sortByProperty != null) {
                            ((Column)child).setSortBy(sortByProperty);
                        }
                        if (filterByProperty != null) {
                            ((Column)child).setFilterBy(filterByProperty);
                        }
                        if (disabledSelectionVE == null) continue;
                        dt.setValueExpression("disabledSelection", disabledSelectionVE);
                        continue;
                    }
                    if (!(child instanceof Columns)) continue;
                    String sortByExpression = this.convertDynamicExpression(var, child.getValueExpression("sortBy"));
                    String filterByExpression = this.convertDynamicExpression(var, child.getValueExpression("filterBy"));
                    if (sortByExpression != null) {
                        ((Columns)child).setValueExpression("sortBy", this.createValueExpression(context, sortByExpression));
                    }
                    if (filterByExpression == null) continue;
                    ((Columns)child).setValueExpression("filterBy", this.createValueExpression(context, filterByExpression));
                }
            }
            dt.setExpressionsAdapted();
        }
    }

    private String convertStaticExpression(String var, ValueExpression ve) {
        String expressionString;
        int varIndex;
        if (ve != null && (varIndex = (expressionString = ve.getExpressionString()).indexOf("#{" + var + '.')) == 0) {
            return expressionString.substring(3 + var.length(), expressionString.length() - 1);
        }
        return null;
    }

    private String convertDynamicExpression(String var, ValueExpression ve) {
        String expressionString;
        int varIndex;
        if (ve != null && (varIndex = (expressionString = ve.getExpressionString()).indexOf("#{" + var + '[')) == 0) {
            return expressionString.substring(3 + var.length(), expressionString.length() - 2);
        }
        return null;
    }

    private ValueExpression createValueExpression(FacesContext context, String expression) {
        ELContext elContext = context.getELContext();
        return context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + expression + "}", Object.class);
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }
}

