/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanymenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectmanymenu.SelectManyMenu;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectManyMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectMany", "javax.faces.Menu").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyMenu menu = (SelectManyMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all" : "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = menu.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !menu.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, menu, clientId, selectItems);
        this.encodeList(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyMenu menu) throws IOException {
        String clientId = menu.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyMenu", menu.resolveWidgetVar(), clientId).attr("disabled", menu.isDisabled(), false).attr("showCheckbox", menu.isShowCheckbox(), false);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    protected void encodeInput(FacesContext context, SelectManyMenu menu, String clientId, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("size", (Object)"2", null);
        if (menu.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        if (menu.getOnclick() != null) {
            writer.writeAttribute("onclick", (Object)menu.getOnclick(), null);
        }
        if (menu.getOndblclick() != null) {
            writer.writeAttribute("ondblclick", (Object)menu.getOndblclick(), null);
        }
        this.encodeSelectItems(context, menu, selectItems);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        boolean customContent = menu.getVar() != null;
        boolean showCheckbox = menu.isShowCheckbox();
        if (customContent) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.startElement("tbody", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            for (SelectItem selectItem : selectItems) {
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("ul");
        }
    }

    protected void encodeItem(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter, boolean customContent, boolean showCheckbox) throws IOException {
        Object itemValue;
        Object valuesArray;
        String itemClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean disabled = option.isDisabled() || menu.isDisabled();
        String string = itemClass = disabled ? "ui-selectlistbox-item ui-corner-all ui-state-disabled" : "ui-selectlistbox-item ui-corner-all";
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        if (selected) {
            itemClass = itemClass + " ui-state-highlight";
        }
        if (customContent) {
            String var = menu.getVar();
            context.getExternalContext().getRequestMap().put(var, option.getValue());
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (option.getDescription() != null) {
                writer.writeAttribute("title", (Object)option.getDescription(), null);
            }
            if (showCheckbox) {
                writer.startElement("td", null);
                RendererUtils.encodeCheckbox(context, selected);
                writer.endElement("td");
            }
            for (UIComponent child : menu.getChildren()) {
                if (!(child instanceof Column) || !child.isRendered()) continue;
                writer.startElement("td", null);
                child.encodeAll(context);
                writer.endElement("td");
            }
            writer.endElement("tr");
        } else {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            if (showCheckbox) {
                RendererUtils.encodeCheckbox(context, selected);
            }
            if (option.isEscape()) {
                writer.writeText((Object)option.getLabel(), null);
            } else {
                writer.write(option.getLabel());
            }
            writer.endElement("li");
        }
    }

    protected void encodeSelectItems(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.write(option.getLabel());
        writer.endElement("option");
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context) + "_input";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public String getHighlighter() {
        return "listbox";
    }
}

