/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.validation.Validation;

public class ConfigContainer {
    private static final Logger LOG = Logger.getLogger(ConfigContainer.class.getName());
    private boolean validateEmptyFields = false;
    private boolean partialSubmitEnabled = false;
    private boolean resetValuesEnabled = false;
    private boolean interpretEmptyStringAsNull = false;
    private boolean rightToLeft = false;
    private String secretKey = null;
    private String pushServerURL = null;
    private String theme = null;
    private boolean clientSideValidationEnabled = false;
    private String uploader = null;
    private boolean beanValidationAvailable = false;
    private boolean stringConverterAvailable = false;
    private boolean jsf22 = false;
    private String buildVersion = null;

    public ConfigContainer(FacesContext context) {
        this.initConfig(context);
        this.initConfigFromContextParams(context);
        this.initBuildProperties();
    }

    private void initConfig(FacesContext context) {
        this.beanValidationAvailable = this.checkIfBeanValidationIsAvailable();
        this.jsf22 = this.detectJSF22();
        this.stringConverterAvailable = null != context.getApplication().createConverter(String.class);
    }

    private void initConfigFromContextParams(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        value = externalContext.getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
        this.interpretEmptyStringAsNull = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.DIR");
        this.rightToLeft = value == null ? false : value.equalsIgnoreCase("rtl");
        value = externalContext.getInitParameter("primefaces.SUBMIT");
        this.partialSubmitEnabled = value == null ? false : value.equalsIgnoreCase("partial");
        value = externalContext.getInitParameter("primefaces.RESET_VALUES");
        this.resetValuesEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.SECRET");
        this.secretKey = value == null ? "primefaces" : value;
        value = externalContext.getInitParameter("primefaces.CLIENT_SIDE_VALIDATION");
        this.clientSideValidationEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.UPLOADER");
        this.uploader = value == null ? "auto" : value;
        this.pushServerURL = externalContext.getInitParameter("primefaces.PUSH_SERVER_URL");
        this.theme = externalContext.getInitParameter("primefaces.THEME");
        value = externalContext.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
        if (null == value) {
            value = (String)externalContext.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
        }
        this.validateEmptyFields = value == null || value.equals("auto") ? this.beanValidationAvailable : Boolean.valueOf(value);
    }

    private void initBuildProperties() {
        Properties buildProperties = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/META-INF/maven/org.primefaces/primefaces/pom.properties");
            buildProperties.load(is);
            this.buildVersion = buildProperties.getProperty("version");
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not load pom.properties", e);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkIfBeanValidationIsAvailable() {
        boolean available = false;
        try {
            available = Class.forName("javax.validation.Validation") != null;
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
        if (available) {
            try {
                Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "BV not available - Could not build default ValidatorFactory.");
                available = false;
            }
        }
        return available;
    }

    private boolean detectJSF22() {
        String version = FacesContext.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version.startsWith("2.2");
        }
        try {
            Class.forName("javax.faces.flow.Flow");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public boolean isValidateEmptyFields() {
        return this.validateEmptyFields;
    }

    public boolean isBeanValidationAvailable() {
        return this.beanValidationAvailable;
    }

    public boolean isPartialSubmitEnabled() {
        return this.partialSubmitEnabled;
    }

    public boolean isInterpretEmptyStringAsNull() {
        return this.interpretEmptyStringAsNull;
    }

    public boolean isRightToLeft() {
        return this.rightToLeft;
    }

    public boolean isStringConverterAvailable() {
        return this.stringConverterAvailable;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isAtLeastJSF22() {
        return this.jsf22;
    }

    public boolean isResetValuesEnabled() {
        return this.resetValuesEnabled;
    }

    public boolean isClientSideValidationEnabled() {
        return this.clientSideValidationEnabled;
    }

    public String getUploader() {
        return this.uploader;
    }

    public String getPushServerURL() {
        return this.pushServerURL;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }
}

