/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.carousel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.carousel.Carousel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class CarouselRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Carousel carousel;
        String clientId;
        String firstParam;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(firstParam = (clientId = (carousel = (Carousel)component).getClientId(context)) + "_first")) {
            carousel.setFirstVisible(Integer.parseInt((String)params.get(firstParam)));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Carousel carousel = (Carousel)component;
        this.encodeMarkup(context, carousel);
        this.encodeScript(context, carousel);
    }

    private void encodeScript(FacesContext context, Carousel carousel) throws IOException {
        String clientId = carousel.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Carousel", carousel.resolveWidgetVar(), clientId);
        wb.attr("firstVisible", carousel.getFirstVisible(), 0).attr("circular", carousel.isCircular(), false).attr("vertical", carousel.isVertical(), false).attr("numVisible", carousel.getNumVisible(), 3).attr("autoplayInterval", carousel.getAutoPlayInterval(), 0).attr("dropDownTemplate", carousel.getDropdownTemplate(), null).attr("pageLinks", carousel.getPageLinks(), 3).attr("effect", carousel.getEffect(), null).attr("effectDuration", carousel.getEffectDuration(), Integer.MIN_VALUE).attr("easing", carousel.getEasing(), null);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = carousel.getClientId(context);
        String style = carousel.getStyle();
        String styleClass = carousel.getStyleClass();
        styleClass = styleClass == null ? "ui-carousel ui-widget ui-widget-content ui-corner-all" : "ui-carousel ui-widget ui-widget-content ui-corner-all " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, carousel);
        this.encodeContent(context, carousel);
        this.encodeFooter(context, carousel);
        this.encodeStateField(context, carousel);
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemStyleClass = carousel.getItemStyleClass();
        itemStyleClass = itemStyleClass == null ? "ui-carousel-item ui-widget-content ui-corner-all" : "ui-carousel-item ui-widget-content ui-corner-all " + itemStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(carousel.isVertical() ? "ui-carousel-viewport ui-carousel-vertical-viewport" : "ui-carousel-viewport"), null);
        writer.startElement("ul", null);
        if (carousel.getVar() != null) {
            for (int i = 0; i < carousel.getRowCount(); ++i) {
                carousel.setRowIndex(i);
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChildren(context, (UIComponent)carousel);
                writer.endElement("li");
            }
            carousel.setRowIndex(-1);
        } else {
            for (UIComponent kid : carousel.getChildren()) {
                if (!kid.isRendered()) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChild(context, kid);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean vertical = carousel.isVertical();
        int numVisible = carousel.getNumVisible();
        int pageCount = carousel.getVar() != null ? (int)Math.ceil((double)carousel.getRowCount() / (1.0 * (double)numVisible)) : carousel.getRenderedChildCount();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-header ui-widget-header ui-corner-all", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-header-title", null);
        UIComponent facet = carousel.getFacet("header");
        String text = carousel.getHeaderText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("div");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(vertical ? "ui-carousel-button ui-carousel-next-button ui-icon ui-icon-circle-triangle-s" : "ui-carousel-button ui-carousel-next-button ui-icon ui-icon-circle-triangle-e"), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(vertical ? "ui-carousel-button ui-carousel-prev-button ui-icon ui-icon-circle-triangle-n" : "ui-carousel-button ui-carousel-prev-button ui-icon ui-icon-circle-triangle-w"), null);
        writer.endElement("span");
        if (pageCount <= carousel.getPageLinks()) {
            this.encodePageLinks(context, carousel, pageCount);
        } else {
            this.encodeDropDown(context, carousel, pageCount);
        }
        writer.endElement("div");
    }

    protected void encodePageLinks(FacesContext context, Carousel carousel, int pageCount) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-page-links", null);
        for (int i = 0; i < pageCount; ++i) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)"ui-icon ui-carousel-page-link ui-icon-radio-off", null);
            writer.endElement("a");
        }
        writer.endElement("div");
    }

    protected void encodeDropDown(FacesContext context, Carousel carousel, int pageCount) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String template = carousel.getDropdownTemplate();
        writer.startElement("select", null);
        writer.writeAttribute("name", (Object)(carousel.getClientId(context) + "_dropdown"), null);
        writer.writeAttribute("class", (Object)"ui-carousel-dropdown ui-widget ui-state-default ui-corner-left", null);
        for (int i = 0; i < pageCount; ++i) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)(i + 1), null);
            writer.write(template.replaceAll("\\{page\\}", String.valueOf(i + 1)));
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeFooter(FacesContext context, Carousel carousel) throws IOException {
        UIComponent facet = carousel.getFacet("footer");
        String text = carousel.getFooterText();
        if (facet == null && text == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-footer ui-widget-header ui-corner-all", null);
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("div");
    }

    protected void encodeStateField(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = carousel.getClientId(context) + "_first";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)carousel.getFirst(), null);
        writer.endElement("input");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }
}

