// Pomaga w wybraniu wygldu odpowiedniego dla uywanego 
// systemu operacyjnego
function okreslBiezacyOSUI() {
    var ua = navigator.userAgent;
    if (ua.indexOf("Mac") != -1) {
        if (ua.indexOf("OS X") != -1 || ua.indexOf("MSIE 5.2") != -1) {
            return "macosX";
        } else {
            return "macos9";
        }
    } else if (ua.indexOf("Windows XP") != -1 || ua.indexOf("NT 5.1") != -1) {
        return "winxp";
    } else if ((document.compatMode && document.compatMode != "BackComp") || 
        (navigator.product && navigator.product == "Gecko")) {
        // Win9x i zgodny z CSS
        return "win9x";
    } else {
        // domylny dla trybu "sztuczek" Windows 9x, Unix/Linux, 
        // oraz wszelkich pozostaych
        return "win9xQ";
    }
}
var biezacyOS = okreslBiezacyOSUI();

// Wczytanie arkusza stylw zalenego od systemu operacyjnego,
// uywanego do okrelania wygldu pseudo-okna
document.write("<link rel='stylesheet' type='text/css' href='dialogLayer_" + biezacyOS + ".css'>");

//******************************
//  POCZTEK KODU PSEUDO-OKNA
//******************************/

// Jeden obiekt ledzi biec warstw pseudo-okna.
var dialogWarstwa = {warstwa:null, widoczne:false};

// Wyrodkowanie elementu w aktualnym oknie (ramce).
// Nazwa elementu jest przekazywana jako argument 
// wywoania funkcji.
function wysrodkujWOknie(idElem) {
    // 'obiekt' jest obiektem pozycjonowanym
    var obiekt = pobierzObiektElem(idElem);
    // wspczynniki przewijania 
    var przewX = 0, przewY = 0;
    if (document.body && typeof document.body.scrollTop != "undefined") {
        przewX += document.body.scrollLeft;
        przewY += document.body.scrollTop;
        if (document.body.parentNode && 
            typeof document.body.parentNode.scrollTop != "undefined") {
            przewX += document.body.parentNode.scrollLeft;
            przewY += document.body.parentNode.scrollTop
        }
    } else if (typeof window.pageXOffset != "undefined") {
        przewX += window.pageXOffset;
        przewY += window.pageYOffset;
    }
    var x = Math.round((pobierzWewnSzerOkna()/2) - 
        (pobierzSzerObiektu(obiekt)/2)) + przewX;
    var y = Math.round((pobierzWewnWysOkna()/2) - 
        (pobierzWysObiektu(obiekt)/2)) + przewY;
    przesunDo(obiekt, x, y);
}

function inicjujDialog() {
    document.getElementById("przyciskzamknij").src = "closeBox_" + biezacyOS + ".jpg";
    dialogWarstwa.warstwa = document.getElementById("pseudoOkno");
}

// Konfiguruje i wywietla pseudo-okno.
// Parametru:
//    url -- adres URL strony/ukadu ramek, ktry ma by wywietlony 
//           w elemencie iframe
//    funkcjaWynikowa -- odwoanie do funkcji zdefiniowanej na tej 
//                       stronie, ktra ma przetwarza dane zwrcone
//                       z okna dialogowego
//    argumenty -- [opcjonalny] dowolne dane, ktre naley przekaza
//                 do okna
function otworzDialog(url, tytul, funkcjaWynikowa, argumenty) {
    if (!dialogWarstwa.widoczne) {
        // Inicjalizacja waciwoi obiektu okna dialogowego.
        dialogWarstwa.url = url;
        dialogWarstwa.tytul = tytul;
        dialogWarstwa.returnFunc = funkcjaWynikowa;
        dialogWarstwa.argumenty = argumenty;
        dialogWarstwa.wartoscWynikowa = "";
        
        // pobranie strony o podanym adresie
        document.getElementById("ramkazawartosci").src = url;
        
        // okrelenie tytuu
        document.getElementById("tytulPaska").firstChild.nodeValue = tytul;
        
        // wyrodkowanie okna w oknie przegldarki lub ramce
        dialogWarstwa.warstwa.style.visibility = "hidden";
        dialogWarstwa.warstwa.style.display = "block"
        wysrodkujWOknie("pseudoOkno");
        
        // wywietlamy okno i ustawiamy flag widocznoci
        dialogWarstwa.warstwa.style.visibility = "visible"
        dialogWarstwa.widoczne = true;
     }

}

function zamknijDialog() {
    dialogWarstwa.warstwa.style.display = "none"
    dialogWarstwa.widoczne = false;
}
//**************************
//  KONIEC KODU PSEUDO-OKNA
//**************************/
