/* simModal.js */
/*
    Przykad zaczerpnity z polskiej edycji ksiki 
    "JavaScript i DHTML. Receptury"
    Wydawnictwo Helion, Gliwice
    Copyright 2003 Danny Goodman
*/
// Flaga globalna dla obsugi zdarze w sposb charakterystyczna dla Netscape 4.
var Nav4 = ((navigator.appName == "Netscape") && (parseInt(navigator.appVersion) == 4))

// Obiekt ledzcy modalne okno dialogowe wywietlone w biecym oknie przegldarki.
var oknoDialogowe = new Object();

// Funkcja obsugujca zdarzenia, uniemoliwiajca w przegldarce Netscape 4
// dziaanie pocze i formularzy w Netscapie 4, w momencie gdy okno 
// dialogowe jest widoczne.
function funKoniec() {
    if (oknoDialogowe.win && !oknoDialogowe.win.closed) {
        oknoDialogowe.win.focus();
        return false;
    }
}

// Poniewa poczenia w niektrych przegladarkach nie mog by 
// tak na prawd wyczone, zapisujemy ich procedury obsugi zdarze
// onclick oraz onmouseout, na czas gdy zdarzenia te bd "wyczone".
// Zostan one odtworzone po ponownym udostpnieniu okna gwnego.
var laczeKlikniecia;

// Wyczenie elementw formularzy i pocze we wszystkich ramkach.
function wylaczFormularze() {
    laczeKlikniecia = new Array();
    for (var i = 0; i < document.forms.length; i++) {
        for (var j = 0; j < document.forms[i].elements.length; j++) {
            document.forms[i].elements[j].disabled = true;
        }
    }
    for (i = 0; i < document.links.length; i++) {
        laczeKlikniecia[i] = {click:document.links[i].onclick, up:null};
        laczeKlikniecia[i].up = document.links[i].onmouseup;
        document.links[i].onclick = funKoniec;
        document.links[i].onmouseup = funKoniec;
        document.links[i].disabled = true;
    }
    window.onfocus = sprawdzModalnosc;
    document.onclick = sprawdzModalnosc;
}

// Przywrcenie oryginalnego dziaania wszystkich elementw i pocze.
function wlaczFormularze() {
    for (var i = 0; i < document.forms.length; i++) {
        for (var j = 0; j < document.forms[i].elements.length; j++) {
            document.forms[i].elements[j].disabled = false;
        }
    }
    for (i = 0; i < document.links.length; i++) {
        document.links[i].onclick = laczeKlikniecia[i].click;
        document.links[i].onmouseup = laczeKlikniecia[i].up;
        document.links[i].disabled = false;
    }
}

// Przechwytujemy wszystkie zdarzenia Navigatora, ktre mog dotrze 
// do elementw formularza gdy okno dialogowe bdzie otworzone.
// W IE wyczamy elementy formularza.
function blokujZdarzenia() {
    if (Nav4) {
        window.captureEvents(Event.CLICK | Event.MOUSEDOWN | Event.MOUSEUP | Event.FOCUS);
        window.onclick = funKoniec;
    } else {
        wylaczFormularze();
    }
    window.onfocus = sprawdzModalnosc;
}

// W momencie zamykania okna dialogowego odtwarzamy oryginalne sposoby obsugi 
// zdarze w oknie gwnym.
function odblokujZdarzenia() {
    if (Nav4) {
        window.releaseEvents(Event.CLICK | Event.MOUSEDOWN | Event.MOUSEUP | Event.FOCUS);
        window.onclick = null;
        window.onfocus = null;
    } else {
        wlaczFormularze();
    }
}

// Generacja modalnego okna dialogowego.
// Parametry:
//    url -- adres URL strony/ukadu ramek wywietlanej w oknie dialogowym
//    szerokosc -- szeroko okna wyraona w pikselach
//    wysokosc -- wysoko okna wyraona w pikselach
//    funkcjaWyn -- odwoanie do funkcji (zdfiniowanej na tej stronie)
//                  ktra ma co zrobi z danymi zwrconymi z okna dialogowego
//    argumenty -- [opcjonalny] dowolne dane jakie naley przekaza do okna dialogowego
function wyswietlSymDialog(url, szerokosc, wysokosc, funkcjaWyn, argumenty) {
    if (!oknoDialogowe.win || (oknoDialogowe.win && oknoDialogowe.win.closed)) {
        // Inicjalizacja waciwoi obiektu modalnego okna dialogowego.
        oknoDialogowe.url = url;
        oknoDialogowe.szerokosc = szerokosc;
        oknoDialogowe.wysokosc = wysokosc;
        oknoDialogowe.funkcjaWyn = funkcjaWyn;
        oknoDialogowe.argumenty = argumenty;
        oknoDialogowe.wartoscWynikowa = "";
        // Nazwa powinna by unikalna.
        oknoDialogowe.nazwa = (new Date()).getSeconds().toString();
        // Okrelamy atrybuty okna i staramy si je wyrodkowa.
        if (window.screenX) {              // Netscape 4+
            // Wyrodkowujemy na oknie gwnym.
            oknoDialogowe.lewo = window.screenX + 
               ((window.outerWidth - oknoDialogowe.szerokosc) / 2);
            oknoDialogowe.gora = window.screenY + 
               ((window.outerHeight - oknoDialogowe.wysokosc) / 2);
            var atrybuty = "screenX=" + oknoDialogowe.lewo + 
               ",screenY=" + oknoDialogowe.gora + ",resizable=no,width=" + 
               oknoDialogowe.szerokosc + ",height=" + oknoDialogowe.wysokosc;
        } else if (window.screenLeft) {    // IE 5+/Windows 
            // Wyrodkowujemy (bardziej lub mniej precyzyjnie) w gwnym oknie Internet Explorera.
            // Zaczynamy od oszacowania wielkoci okna,
            // uwzgldniajc przy tym tryb zgodnoci z CSS IE6+ 
            var CSSCompat = (document.compatMode && document.compatMode != "BackCompat");
            window.outerWidth = (CSSCompat) ? document.body.parentElement.clientWidth : document.body.clientWidth;
            window.outerHeight = (CSSCompat) ? document.body.parentElement.clientHeight : document.body.clientHeight;
            window.outerHeight -= 80;
            oknoDialogowe.lewo = parseInt(window.screenLeft+ 
               ((window.outerWidth - oknoDialogowe.szerokosc) / 2));
            oknoDialogowe.gora = parseInt(window.screenTop + 
               ((window.outerHeight - oknoDialogowe.wysokosc) / 2));
            var atrybuty = "left=" + oknoDialogowe.lewo + 
               ",top=" + oknoDialogowe.gora + ",resizable=no,width=" + 
               oknoDialogowe.szerokosc + ",height=" + oknoDialogowe.wysokosc;
        } else {                           // caa reszta
            // Najlepsze co moemy zrobi to wyrodkowa na ekranie.
            //
            oknoDialogowe.lewo = (screen.width - oknoDialogowe.szerokosc) / 2;
            oknoDialogowe.gora = (screen.height - oknoDialogowe.wysokosc) / 2;
            var atrybuty = "left=" + oknoDialogowe.left + ",top=" + 
               oknoDialogowe.top + ",resizable=no,width=" + oknoDialogowe.szerokosc + 
               ",height=" + oknoDialogowe.wysokosc;
        }
        
        // Generujemy okno dialogowe i upewniamy si e posiada ono fokus.
        oknoDialogowe.win=window.open(oknoDialogowe.url, oknoDialogowe.nazwa, atrybuty);
        oknoDialogowe.win.focus();
    } else {
        oknoDialogowe.win.focus();
    }
}

// Funkcja wywoywana przez procedur obsugi zdarze onfocus KADEJ ramki,
// jesli okno dialogowe jest widoczne to zwraca do niego fokus.
function sprawdzModalnosc() {
    setTimeout("zakonczSprawdzanie()", 50);
    return true;
}


function zakonczSprawdzanie() {
    if (oknoDialogowe.win && !oknoDialogowe.win.closed) {
        oknoDialogowe.win.focus();
    }
}

//// ROZWIZANIE STOSOWANE W DOKUMENTAC ZAWIERAJCYCH RAMKI
//
//// Wyczenie elementw formularzy i pocze we wszystkich ramkach.
//function wylaczFormularze() {
//    laczeKlikniecia = new Array();
//    for (var h = 0; h < frames.length; h++) {
//        for (var i = 0; i < frames[h].document.forms.length; i++) {
//            for (var j = 0; j < frames[h].document.forms[i].elements.length; j++) {
//                frames[h].document.forms[i].elements[j].disabled = true;
//            }
//        }
//        laczeKlikniecia[h] = new Array();
//        for (i = 0; i < frames[h].document.links.length; i++) {
//            laczeKlikniecia[h][i] = {click:frames[h].document.links[i].onclick, up:null};
//            laczeKlikniecia[h][i].up = frames[h].document.links[i].onmouseup;
//            frames[h].document.links[i].onclick = funKoniec;
//            frames[h].document.links[i].onmouseup = funKoniec;
//            frames[h].document.links[i].disabled = true;
//       }
//        frames[h].window.onfocus = sprawdzModalnosc;
//        frames[h].document.onclick = sprawdzModalnosc;
//    }
//}
//
//// Przywrcenie oryginalnego dziaania wszystkich elementw i pocze.
//function wlaczFormularze() {
//    for (var h = 0; h < frames.length; h++) {
//        for (var i = 0; i < frames[h].document.forms.length; i++) {
//            for (var j = 0; j < frames[h].document.forms[i].elements.length; j++) {
//                frames[h].document.forms[i].elements[j].disabled = false;
//            }
//       }
//        for (i = 0; i < frames[h].document.links.length; i++) {
//        	if (typeof frames[h].document.links[i].disabled != "undefined") {
//        	    frames[h].document.links[i].disabled = false;
//        	} else {
//                frames[h].document.links[i].onclick = linkClicks[h][i];
//            }
//        }
//    }
//}
////    KONIEC ROZWIZANIA DLA RAMEK
