/********************************
    TWORZENIE PASKW PRZEWIJANIA
*********************************/
// zmienne globalne
var przewWlaczone = false;
var interwalPrzew;
var paskiPrzew = new Array();

// odczyt rzeczywistych wartoci wasnoci stylu
function stylElementu(IdElem, WlasnoscStyluIE, WlasnoscStyluCSS) {
    var elem = document.getElementById(IdElem);
    if (elem.currentStyle) {
        return elem.currentStyle[WlasnoscStyluIE];
    } else if (window.getComputedStyle) {
        var styl = window.getComputedStyle(elem, "");
        return styl.getPropertyValue(WlasnoscStyluCSS);
    }
    return "";
}

// konstruktor paska przewijania
function pasekPrzew(idElemBazowego, idWlasc, idWlascTresci) {
    this.idElemBazowego = idElemBazowego;
    this.idWlasc = idWlasc;
    this.idWlascTresci = idWlascTresci;
    this.indeks = paskiPrzew.length;

    // jednorazowe obliczenia, ktrych wyniki s wykorzystywane w dalszych operacjach	
    this.elemBazowy = document.getElementById(idElemBazowego);
    this.elemWlasc = document.getElementById(idWlasc);
    this.elemTresci = document.getElementById(idWlascTresci);
    this.wysWlasc = parseInt(stylElementu(idWlasc, "height", "height"));
    this.szerWlasc = parseInt(stylElementu(idWlasc, "width", "width"));
    this.obramWlasc = parseInt(stylElementu(idWlasc, "borderTopWidth", 
        "border-top-width")) * 2;
    this.wysTresci = Math.abs(parseInt(this.elemTresci.style.top));
    this.szerTresci = this.elemTresci.offsetWidth;
    this.rozmCzcionkiTresci = parseInt(stylElementu(this.idWlascTresci, 
        "fontSize", "font-size"));
    this.wysPrzewTresci = this.elemTresci.scrollHeight;

    // utworzenie obiektu wypeniacza, ktrego domylne wartoci (zgodne z CSS)
    // s zerami; wartoci dla trybu zgodnoci z wczeniejszymi przegldarkami zdefiniowano poniej	
    this.wyp = {wlacz:false, obramWlasc:0, obramPrzew:0, odstepTresci:0};
    if (navigator.appName == "Microsoft Internet Explorer" && 
        navigator.userAgent.indexOf("Win") != -1 && 
        (typeof document.compatMode == "undefined" || 
        document.compatMode == "BackCompat")) {
        this.wyp.wlacz = true;
        this.wyp.obramWlasc = this.obramWlasc;
        this.wyp.odstepTresci = parseInt(stylElementu(idWlascTresci, 
        "padding", "padding"));
     }

    // wartoci ustalane podczas inicjowania paska przewijania
    this.prowadnica = null;
    this.przycWGore = null;
    this.przycWDol = null;
    this.suwak = null;
    this.wysPrzyc = 0;
    this.wysSuwaka = 0;
    this.wysProwadnicy = 0
    this.obszarPrzeciagania = {lewaKrawedz:0, gornaKrawedz:0, prawaKrawedz:0, dolnaKrawedz:0}

    // utworzenie kontrolki paska przewijania dla bazowego elementu div	
    this.dodajPrzewijanie = dodajPasekPrzew;
}

// utworzenie elementw paska przewijania i umieszczeni ich w "pseudooknie"
function dodajPasekPrzew() {
    // rozmiary rysunkw przycisku i suwaka (ustawiane przez progrmist)
    var wysRys = 16;
    var szerRys = 16;
    var wysSuw = 27;

    // przycisk "w gr", niezbdny do ustalenia rozmiaru prowadnicy suwaka(prowadnica)
    var liniaWGore = document.createElement("img");
    liniaWGore.id = "liniaWGore" + (paskiPrzew.length - 1);
    liniaWGore.className = "liniaWGore";
    liniaWGore.indeks = this.indeks;
    liniaWGore.src = "przewWGore.gif";
    liniaWGore.height = wysRys;
    liniaWGore.width = szerRys;
    liniaWGore.alt = "Przewijanie o jedn lini w gr";
    liniaWGore.style.position = "absolute";
    liniaWGore.style.top = "0px";
    liniaWGore.style.left = "0px";

    // elemen zewntrzny definiuje kolor wybranego obszaru strony i jego trjwymiarowe obramowanie
    var prowadnica = document.createElement("div");
    prowadnica.id = "prowadnica" + (paskiPrzew.length - 1);
    prowadnica.className = "prowadnica";
    prowadnica.indeks = this.indeks;
    prowadnica.style.position = "absolute";
    prowadnica.style.visibility = "hidden";
    prowadnica.style.top = "0px";
    prowadnica.style.left = this.szerWlasc + this.obramWlasc - 
        this.wyp.obramWlasc + "px";
    prowadnica.style.borderTop = "2px solid #666666";
    prowadnica.style.borderLeft = "2px solid #666666";
    prowadnica.style.borderRight= "2px solid #cccccc";
    prowadnica.style.borderBottom= "2px solid #cccccc";
    prowadnica.style.backgroundColor = "#999999";
    if (this.wyp.wlacz) {
        this.wyp.obramPrzew = 2;
    }
    prowadnica.style.width = liniaWGore.width + (this.wyp.obramPrzew * 2) + "px";
    prowadnica.style.height = this.wysWlasc + (this.obramWlasc - 4) - 
        (this.wyp.obramPrzew * 2) + "px";

    // przycisk "w d"
    var liniaWDol = document.createElement("img");
    liniaWDol.id = "liniaWDol" + (paskiPrzew.length - 1);
    liniaWDol.className = "liniaWDol";
    liniaWDol.indeks = this.indeks;
    liniaWDol.src = "przewWDol.gif";
    liniaWDol.height = wysRys;
    liniaWDol.width = szerRys;
    liniaWDol.alt = "Przewijanie o jedn lini w d";
    liniaWDol.style.position = "absolute";
    liniaWDol.style.top = parseInt(this.wysWlasc) + (this.obramWlasc - 4) - 
        (this.wyp.obramWlasc) - liniaWDol.height + "px";
    liniaWDol.style.left = "0px";

    // suwak o staym rozmiarze
    var suwak = document.createElement("img");
    suwak.id = "suwak" + (paskiPrzew.length - 1);
    suwak.indeks = this.indeks;
    suwak.src = "suwak.gif";
    suwak.height = wysSuw;
    suwak.width = szerRys;
    suwak.alt = "Suwak";
    suwak.style.position = "absolute";
    suwak.style.top = liniaWGore.height + "px";
    suwak.style.width = szerRys + "px";
    suwak.style.height = wysSuw + "px";
    suwak.style.left = "0px";

    // ustalenie wartoci wasnoci obiektu pasekPrzew na podstawie
    // parametrw wywietlonych elementw
    this.przycWGore = prowadnica.appendChild(liniaWGore);
    this.suwak = prowadnica.appendChild(suwak);
    this.przycWDol = prowadnica.appendChild(liniaWDol);
    this.prowadnica = this.elemBazowy.appendChild(prowadnica);
    this.wysPrzyc = wysRys;
    this.wysSuwaka = wysSuw;
    this.wysProwadnicy = parseInt(stylElementu(this.prowadnica.id, 
        "height", "height"));
    this.obszarPrzeciagania.lewaKrawedz = 0;
    this.obszarPrzeciagania.gornaKrawedz = this.wysPrzyc;
    this.obszarPrzeciagania.prawaKrawedz = this.wysPrzyc;
    this.obszarPrzeciagania.dolnaKrawedz = this.wysProwadnicy - this.wysPrzyc - 
        (this.wyp.obramPrzew * 2)

    // zdarzenia przetwarzane przez zewntrzny element paska przewijania
    this.prowadnica.onmousedown = kliknieciePrzew;
    this.prowadnica.onmouseup = zatrzymaniePrzew;
    this.prowadnica.oncontextmenu = blokadaZdarzenia;
    this.prowadnica.ondrag = blokadaZdarzenia;

    // kontrolka gotowa do wywietlenia
    this.prowadnica.style.visibility = "visible";
}

/***************************
    FUNKCJE OBSUGI ZDARZE
****************************/
// zdarzenie onmouseup
function zatrzymaniePrzew() {
    przewWlaczone = false;
}

//  niedopuszczenie do wywietlenia menu kontekstowego w systemach Macintosh 
// (przy przytrzymaniu przycisku myszy)
function blokadaZdarzenia(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    zdarzenie.cancelBubble = true;
    return false;
}

// obsuga zdarzenia kliknicia
function kliknieciePrzew(zdarzenie) {
    var rozmCzcionki, wysTresci;
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    var cel = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
    cel = (cel.nodeType == 3) ? cel.parentNode : cel;
    var indeks = cel.indeks;
    rozmCzcionki = paskiPrzew[indeks].rozmCzcionkiTresci;
    switch (cel.className) {
        case "liniaWGore" :
            przewWlaczone = true;
            przewinO(indeks, parseInt(rozmCzcionki));
            interwalPrzew = setInterval("przewinO(" + indeks + ", " + 
                parseInt(rozmCzcionki) + ")", 100);
            zdarzenie.cancelBubble = true;
            return false;
            break;
        case "liniaWDol" :
            przewWlaczone = true;
            przewinO(indeks, -(parseInt(rozmCzcionki)));
            interwalPrzew = setInterval("przewinO(" + indeks + ", -" + 
                parseInt(rozmCzcionki) + ")", 100);
            zdarzenie.cancelBubble = true;
            return false;
            break;
        case "prowadnica" :
            przewWlaczone = true;
            var zdarzY = (zdarzenie.offsetY) ? zdarzenie.offsetY : ((zdarzenie.layerY) ? zdarzenie.layerY : -1);
            if (zdarzY >= 0) {
                var rozmStrony = paskiPrzew[indeks].wysWlasc - rozmCzcionki;
                var stylElemSuwaka = paskiPrzew[indeks].suwak.style;
                // wartoci ujemne pozwalaj przewin dokument w gr
                if (zdarzY > (parseInt(stylElemSuwaka.top) + 
                    paskiPrzew[indeks].wysSuwaka)) {
                    rozmStrony = -rozmStrony;
                }
                przewinO(indeks, rozmStrony);
                interwalPrzew = setInterval("przewinO(" + indeks + ", " + 
                    rozmStrony + ")", 100);
                zdarzenie.cancelBubble = true;
                return false;
            }
    }
    return false;
}

// Przewijanie zawartoci elementu wewntrznego
function przewinO(indeks, px) {
    var pasek = paskiPrzew[indeks];
    var elem = document.getElementById(pasek.idWlascTresci);
    var gora = parseInt(elem.style.top);
    var wysPrzew = parseInt(elem.scrollHeight);
    var wys = pasek.wysWlasc;
    if (przewWlaczone && gora + px >= -wysPrzew + wys && gora + px <= 0) {
        przesun(elem, 0, px);
        uaktualnijSuwak(indeks);
    } else if (gora + px < -wysPrzew + wys) {
        przesunDo(elem, 0, -wysPrzew + wys - pasek.wyp.odstepTresci);
        uaktualnijSuwak(indeks);
        clearInterval(interwalPrzew);
    } else if (gora + px > 0) {
        przesunDo(elem, 0, 0);
        uaktualnijSuwak(indeks);
        clearInterval(interwalPrzew);
    } else {
        clearInterval(interwalPrzew);
    }
}

/*********************************
   SYNCHRONIZACJA SUWAKA I TRECI
**********************************/
// uaktualnienie pozycji suwaka po klikniciu przycisku lub paska wiodcego
function uaktualnijSuwak(indeks) {
    var pasek = paskiPrzew[indeks];
    var dlPaska = pasek.wysProwadnicy - (pasek.wyp.obramPrzew * 2);
    var wysPrzyc = pasek.wysPrzyc;
    dlPaska -= wysPrzyc * 2;
    var elemDok = pasek.elemTresci;
    var goraDok = Math.abs(parseInt(elemDok.style.top));
    var wspPrzew = goraDok/(pasek.wysPrzewTresci - pasek.wysWlasc);
    przesunDo(pasek.suwak, 0, Math.round((dlPaska - pasek.wysSuwaka) * 
        wspPrzew) + wysPrzyc);
}

// ustalenie pozycji treci za pomoc suwaka
function uaktualnijTresc() {
    var indeks = wybranyObiekt.indeks;
    var kontrolka = paskiPrzew[indeks];
    
    var dlPaska = kontrolka.wysProwadnicy - (kontrolka.wyp.obramPrzew * 2);
    var wysPrzyc = kontrolka.wysPrzyc;
    var wysSuwaka = kontrolka.wysSuwaka;
    var goraTla = wysPrzyc;
    var dolTla = dlPaska - wysPrzyc - wysSuwaka;
    var rozmTla = dolTla - goraTla;
    var goraSuwaka = parseInt(stylElementu(kontrolka.suwak.id, "top", "top"));
    var wspPrzew = (goraSuwaka - wysPrzyc)/rozmTla;
    var elemDok = kontrolka.elemTresci;
    var goraDok = Math.abs(parseInt(elemDok.style.top));
    var wysPrzew = kontrolka.wysPrzewTresci;
    var wys = kontrolka.wysWlasc;   
    przesunDo(kontrolka.idWlascTresci, 0, -(Math.round((wysPrzew - wys) * 
        wspPrzew)));
}
/*******************
    PRZECIGANIE
********************/
// Zmienna globalna przechowujca odwoanie do wybranego elementu
var wybranyObiekt;

// Zmienne globalne przechwujce wzgldne wsprzdne kliknicia 
// (wyznaczane w odniesieniu do pooenia elementu)
var przesX, przesY;
var obszar = {lewaKrawedz:0, gornaKrawedz:16, prawaKrawedz:16, dolnaKrawedz:88};


// Ustawienie globalnej referencji aktywnego lub przeciganego obiektu
function wybranyElement(zdarzenie) {
    var cel = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
    cel = (cel.nodeType && cel.nodeType == 3) ? cel.parentNode : cel;
    var idDiv = (cel.id.indexOf("suwak") != -1) ? cel.id : "";
    if (idDiv) {
        if (document.layers) {
            wybranyObiekt = document.layers[idDiv];
        } else if (document.all) {
            wybranyObiekt = document.all(idDiv);
        } else if (document.getElementById) {
            wybranyObiekt = document.getElementById(idDiv);
        }
        podajIndeksZ(wybranyObiekt, 100);
        return;
    }
    wybranyObiekt = null;
    return;
}

// Przeciganie suwaka w obszarze paska przewijania
function przeciagnij(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    var x, y, szer, wys;
    if (wybranyObiekt) {
        if (zdarzenie.pageX) {
            x = zdarzenie.pageX - przesX;
            y = zdarzenie.pageY - przesY;
        } else if (zdarzenie.clientX || zdarzenie.clientY) {
            x = zdarzenie.clientX - przesX;
            y = zdarzenie.clientY - przesY;
        }
        var indeks = wybranyObiekt.indeks ;
        var pasek = paskiPrzew[indeks ];
        var obszar = pasek.obszarPrzeciagania;
        szer = pasek.suwak.width;
        wys = pasek.suwak.height;
        x = (x < obszar.lewaKrawedz) ? obszar.lewaKrawedz : ((x + szer > obszar.prawaKrawedz) ? obszar.prawaKrawedz- szer : x);
        y = (y < obszar.gornaKrawedz) ? obszar.gornaKrawedz : ((y + wys > obszar.dolnaKrawedz) ? obszar.dolnaKrawedz - wys : y);
        przesunDo(wybranyObiekt, x, y);
        uaktualnijTresc();
        zdarzenie.cancelBubble = true;
        return false;
    }
}

// Uaktywnienie wybranego elementu i przesunicie kursora
function wlacz(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie: event;
    wybranyElement(zdarzenie);
    if (wybranyObiekt) {
        if (document.body && document.body.setCapture) {
            // wczenie przechwytywania zdarze w IE/Win
            document.body.setCapture();
        }
        if (zdarzenie.pageX) {
            przesX = zdarzenie.pageX - ((typeof wybranyObiekt.offsetLeft != "undefined") ? 
                     wybranyObiekt.offsetLeft : wybranyObiekt.left);
            przesY = zdarzenie.pageY - ((wybranyObiekt.offsetTop) ? 
                     wybranyObiekt.offsetTop : wybranyObiekt.top);
        } else if (typeof zdarzenie.clientX != "undefined") {
            przesX = zdarzenie.clientX - ((wybranyObiekt.offsetLeft) ? 
                     wybranyObiekt.offsetLeft : 0);
            przesY = zdarzenie.clientY - ((wybranyObiekt.offsetTop) ? 
                     wybranyObiekt.offsetTop : 0);
        }
        return false;
    }
}

// Zwolnienie elementu
function zwolnij(zdarzenie) {
    if (wybranyObiekt) {
        podajIndeksZ(wybranyObiekt, 0);
        if (document.body && document.body.releaseCapture) {
            // zatrzymanie przechwytywania zdarze w IE/Win
            document.body.releaseCapture();
        }
        wybranyObiekt = null;
    }
}


// Przypisanie procedur obsugi zdarze przegldarek Internet Explorer i Netscape Navigator
function inicjujPrzeciaganie() {
    if (document.layers) {
        // wczenie przechwytywania poniszych zdarze w modelu zdarze NN4
        document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEUP);
        return;
    } else if (document.body & document.body.addEventListener) {
        // wczenie przechwytywania poniszych zdarze w modelu zdarze DOM W3C
    	document.addEventListener("mousedown", wlacz, true);
    	document.addEventListener("mousemove", przeciagnij, true);
    	document.addEventListener("mouseup", zwolnij, true);
    	return;
    }
  	document.onmousedown = wlacz;
   	document.onmousemove = przeciagnij;
   	document.onmouseup = zwolnij;
    return;
}