/**********************************
          Zmienne globalne
***********************************/
// zapisanie w pamici podrcznej grafik uywanych w menu 
// (wszystkie te grafiki musz mie t sam wielko)
var grafikaZwiniete = new Image(20, 16);
grafikaZwiniete.src = "oplus.gif";
var grafikaZwinieteStart = new Image(20, 16);
grafikaZwinieteStart.src = "oplusStart.gif";
var grafikaZwinieteEnd = new Image(20, 16);
grafikaZwinieteEnd.src = "oplusEnd.gif";
var grafikaRozwiniete = new Image(20, 16);
grafikaRozwiniete.src = "ominus.gif";
var grafikaRozwinieteStart = new Image(20, 16);
grafikaRozwinieteStart.src = "ominusStart.gif";
var grafikaRozwinieteEnd = new Image(20, 16);
grafikaRozwinieteEnd.src = "ominusEnd.gif";
var grafikaWezel = new Image(20, 16);
grafikaWezel.src = "onode.gif";
var grafikaWezelEnd = new Image(20, 16);
grafikaWezelEnd.src = "onodeEnd.gif";
var grafikaPustyObszar = new Image(20, 16);
grafikaPustyObszar.src = "oempty.gif";
var grafikaLacznik = new Image(20, 16);
grafikaLacznik.src = "ochain.gif";

// miscellaneous globals
var grafikaSzerokosc = "20";
var grafikaWysokosc = "16";
var biezacyStan = "";
var ramkaDocelowaStron = "contentFrame";
// obiekt dokumntu XML
var dokumentXML;

/**********************************
  Przeczenie wywietlania i ikon
***********************************/
// zmiana stanu opcji na przeciwny (rozwinity/zwinity)
function zmienStan(biezacyStan, biezacaWartosc, n) {
    var nowyStan = biezacyStan.substring(0,n);
    nowyStan += biezacaWartosc ^ 1 // bitowy XOR;
    nowyStan += biezacyStan.substring(n+1,biezacyStan.length);
    return nowyStan;
}

// pobranie odpowiedniej wersji obrazkw "minus"
function pobierzStanGrafikiRozwinietaOpc(urlObraka) {
    if (urlObraka.indexOf("Start") != -1) {
        return grafikaRozwinieteStart.src;
    }
    if (urlObraka.indexOf("End") != -1) {
        return grafikaRozwinieteEnd.src;
    }
    return grafikaRozwiniete.src;
}

// pobranie odpowiedniej wersji obrazkw "plus"
function pobierzStanGrafikiZwinietaOpc(urlObraka) {
    if (urlObraka.indexOf("Start") != -1) {
        return grafikaZwinieteStart.src;
    }
    if (urlObraka.indexOf("End") != -1) {
        return grafikaZwinieteEnd.src;
    }
    return grafikaZwiniete.src;
}

// przeczenie stanu elementu nadrzdnego menu, zapisanie nowej wartoci stanu
// funkcja jest wywoywana przez procedury obsugi zdarze elementw grafik
function przelacz(obrazek, numerBloku) {
    var nowyLancuch = "";
    var rozwiniete, n;
    // zmiana acucha opisujcego stan na podstawie informacji z elementu IMG
    rozwiniete = biezacyStan.charAt(numerBloku);
    biezacyStan = zmienStan(biezacyStan, rozwiniete, numerBloku);
    // dynamiczna zmiana stylu
    if (rozwiniete == "0") {
        document.getElementById("OLBlock" + numerBloku).style.display = "block";
        obrazek.src = pobierzStanGrafikiRozwinietaOpc(obrazek.src);
    } else {
        document.getElementById("OLBlock" + numerBloku).style.display = "none";
        obrazek.src = pobierzStanGrafikiZwinietaOpc(obrazek.src);
    }
}

function rozwinWszystko() {
    var nowyStan = "";
    while (nowyStan.length < biezacyStan.length) {
        nowyStan += "1";
    }
    biezacyStan = nowyStan;
    inicjujRozwijanie();
}

function zwinWszystko() {
    var nowyStan = "";
    while (nowyStan.length < biezacyStan.length) {
        nowyStan += "0";
    }
    biezacyStan = nowyStan;
    inicjujRozwijanie();
}

/*********************************
   Generacja kodu HTML menu
**********************************/
// zastosowanie domylnego stanu rozwinicia okrelonego w 
// nagwku menu do okrelenia stanu elementu, w celu 
// uatwienia inicjalizacji zmiennej biezacyStan
function calcBlockState(n) {
    var menu = dokumentXML.getElementsByTagName("body")[0];
    var dlugoscMenu = menu.getElementsByTagName("outline").length;
    // pobranie danych o domylnym rozwiniciu z elementu expansionState 
    var rozwinietyElement = dokumentXML.getElementsByTagName("expansionState")[0];
    var daneElementu = (rozwinietyElement.childNodes.length) ? rozwinietyElement.firstChild.nodeValue.split(",") : null;
    if (daneElementu) {
        for (var j = 0; j < daneElementu.length; j++) {
            if (n == daneElementu[j] - 1) {
                return "1";
            }
        }
    }
    return "0";
}

// liczniki uywane w funkcji generujMenu()
var identyfikatorOpcji = 0;
var identyfikatorBloku = 0;

// generajca kodu HTML menu
function generujMenu(ol, prefiks) {
    var wyniki = "";
    var iloscZagn, hiperlacze, prefiksZagn, ostatnieWezelZagniezdzony;
    ol = (ol) ? ol : dokumentXML.getElementsByTagName("body")[0];
    prefiks = (prefiks) ? prefiks : "";
    if (ol.childNodes[ol.childNodes.length - 1].nodeType == 3) {
        ol.removeChild(ol.childNodes[ol.childNodes.length - 1]);
    }
    for (var i = 0; i < ol.childNodes.length ; i++) {
        if (ol.childNodes[i].nodeType == 3) {
            continue;
        }
        if (ol.childNodes[i].childNodes.length > 0 && ol.childNodes[i].childNodes[ol.childNodes[i].childNodes.length - 1].nodeType == 3) {
             ol.childNodes[i].removeChild(ol.childNodes[i].childNodes[ol.childNodes[i].childNodes.length - 1]);
        }
        iloscZagn = ol.childNodes[i].childNodes.length;
        wyniki += "<div class='OLRow' id='line" + identyfikatorOpcji++ + "'>\n";
        if (iloscZagn > 0) {
            wyniki += prefiks;
            wyniki += "<img id='widget" + (identyfikatorOpcji-1) + "' src='" + ((i== ol.childNodes.length-1) ? grafikaZwinieteEnd.src : (identyfikatorBloku==0) ? grafikaZwinieteStart.src : grafikaZwiniete.src);
            wyniki += "' height=" + grafikaWysokosc + " width=" + grafikaSzerokosc;
            wyniki += " title='Kliknij aby rozwin/zwin opcje podrzdne.' onClick='przelacz(this," + identyfikatorBloku + ")'>";
            hiperlacze =  (ol.childNodes[i].getAttribute("uri")) ? ol.childNodes[i].getAttribute("uri") : "";
            if (hiperlacze) {
                wyniki += "&nbsp;<a href='" + hiperlacze + "' class='itemTitle' title='" + 
                hiperlacze + "' target='" + ramkaDocelowaStron + "'>" ;
            } else {
                wyniki += "&nbsp;<a class='itemTitle' title='" + hiperlacze + "'>";
            }
            wyniki += "<span style='position:relative; top:-3px; height:11px'>&nbsp;" + ol.childNodes[i].getAttribute("text") + "</span></a>";
            biezacyStan += calcBlockState(identyfikatorOpcji-1);
            wyniki += "<span class='OLBlock' blocknum='" + identyfikatorBloku + "' id='OLBlock" + identyfikatorBloku++ + "'>";
            prefiksZagn = prefiks;
            prefiksZagn += (i == ol.childNodes.length - 1) ? 
                       "<img src='" + grafikaPustyObszar.src + "' height=" + grafikaWysokosc + " width=" + grafikaSzerokosc + ">" :
                       "<img src='" + grafikaLacznik.src + "' height=" + grafikaWysokosc + " width=" + grafikaSzerokosc + ">"
            wyniki += generujMenu(ol.childNodes[i], prefiksZagn);
            wyniki += "</span></div>\n";
        } else {
            wyniki += prefiks;
            wyniki += "<img id='widget" + (identyfikatorOpcji-1) + "' src='" + ((i == ol.childNodes.length - 1) ? grafikaWezelEnd.src : grafikaWezel.src);
            wyniki += "' height=" + grafikaWysokosc + " width=" + grafikaSzerokosc + ">";
            hiperlacze =  (ol.childNodes[i].getAttribute("uri")) ? ol.childNodes[i].getAttribute("uri") : "";
            if (hiperlacze) {
                wyniki += "&nbsp;<a href='" + hiperlacze + "' class='itemTitle' title='" + 
                hiperlacze + "' target='" + ramkaDocelowaStron + "'>";
            } else {
                wyniki += "&nbsp;<a class='itemTitle' title='" + hiperlacze + "'>";
            }
            wyniki +="<span style='position:relative; top:-3px; height:11px'>" +  ol.childNodes[i].getAttribute("text") + "</span></a>";
            wyniki += "</div>\n";
        }
    }
    return wyniki;
}

/*********************************
     Inicjalizacja menu
**********************************/
// rozwinicie opcji okrelonych w elemencie expansionState 
function inicjujRozwijanie() {
    for (var i = 0; i < biezacyStan.length; i++) {
        if (biezacyStan.charAt(i) == 1) {
            document.getElementById("OLBlock" + i).style.display = "block";
        } else {
            document.getElementById("OLBlock" + i).style.display = "none";
        }
    }
}

function zakonczInicjalizacje() {
        // pobranie danych meny z dokumentu XML, w celu ich przeanalizowania
        // i wygenerowania kodu HTML menu
        var ol = dokumentXML.getElementsByTagName("body")[0];
        // zapisanie kodu HTML caego menu w elemencie span
        var olHTML = "<span id='renderedOL'>" + generujMenu(ol) + "</span>";
        // wstawienie caego kodu HTML do elementu div o identyfikatorze 'zawartscMenu'
        document.getElementById("zawartoscMenu").innerHTML = olHTML;
        inicjujRozwijanie();
}

function kontynuujPobieranie(plikXML) {
    dokumentXML.load(escape(plikXML));
    // to opnienie jest konieczne, aby IE mg zakoczy pobieranie zawartoci pliku
    setTimeout("zakonczInicjalizacje()", 300);
}

// sprawdzenie czy przegldarka dysponuje niezbdnymi moliwociami i jest w stanie
// wczyta zewntrzny plik .xml
function pobierzDokumentXML(plikXML) {
    if (document.implementation && document.implementation.createDocument) {
        // to rozwizanie stosowane w DOM W3C, obsugiwane aktualnie jedynie w NN6
        dokumentXML = document.implementation.createDocument("", "theXdoc", null);
    } else if (typeof ActiveXObject != "undefined") {
        // sprawdzenie czy prawdziwy obiekt jest dostpny (egnaj, IE5/Mac)
        if (document.getElementById("msxml").async) {
            dokumentXML = new ActiveXObject("Msxml.DOMDocument");
        }
    }
    if (dokumentXML && typeof dokumentXML.load != "undefined") {
        // Netscape 6+ potrzebuje tego opnienia, eby zakoczy pobierania, 
        // pocztek dwuetapowej sekwencji czynnoci
        setTimeout("kontynuujPobieranie('" + plikXML + "')", 50);
    } else {
        var reply = confirm("Ten przykad wymaga przegldarki obsugujcej dane XML, takiej jak IE5+/Windows lub Netscape 6+.\n \nCzy wrci na poprzedni stron?");
        if (reply) {
            history.back();
        }
    }
}

// inicjalizacja
function inicjujMenuXML(plikXML) {
    pobierzDokumentXML(plikXML);
}

