/* cookies.js */
/*
    Przykad zaczerpnity z polskiej edycji ksiki 
    "JavaScript i DHTML. Receptury"
    Wydawnictwo Helion, Gliwice
    Copyright 2003 Danny Goodman
*/

// funkcja pomocnicza suca do pobierania przyszej daty wyganicia 
// zapisanej w poprawnym formacie; przekazywane s do niej trzy wartoci
// cakowite okrelajce ilo dni, godzin i minut od chwili obecnej, 
// do zamierzonej chwili wyganicia cookie; wszystkie trzy argumenty 
// s wymagane, a zatem, w razie koniecznoci, naley przekaza zera.
function pobierzDateWyg(dni, godziny, minuty) {
    var dataWyg = new Date();
    if (typeof dni == "number" && typeof godziny == "number" && typeof minuty == "number") {
        dataWyg.setDate(dataWyg.getDate() + parseInt(dni));
        dataWyg.setHours(dataWyg.getHours() + parseInt(godziny));
        dataWyg.setMinutes(dataWyg.getMinutes() + parseInt(minuty));
        return dataWyg.toGMTString();
    }
}

// funkcja pomocnicza wywoywana przez getCookie()
function pobierzWartCookie(offset) {
    var koniecLanc = document.cookie.indexOf (";", offset);
    if (koniecLanc == -1) {
        koniecLanc = document.cookie.length;
    }
    return unescape(document.cookie.substring(offset, koniecLanc));
}

// gwna funkcja do pobierania cookie na podstawie nazwy
function pobierzCookie(nazwa) {
    var arg = nazwa + "=";
    var dlugoscA = arg.length;
    var dlugoscC = document.cookie.length;
    var i = 0;
    while (i < dlugoscC) {
        var j = i + dlugoscA;
        if (document.cookie.substring(i, j) == arg) {
            return pobierzWartCookie(j);
        }
        i = document.cookie.indexOf(" ", i) + 1;
        if (i == 0) break; 
    }
    return null;
}

// zapisanie wartoci cookie wraz z dodatkowymi informacjami (jeli to konieczne)
function ustawCookie(nazwa, wartosc, wygasa, sciezka, domena, bezpieczne) {
    document.cookie = nazwa + "=" + escape (wartosc) +
        ((wygasa) ? "; expires=" + wygasa : "") +
        ((sciezka) ? "; path=" + sciezka : "") +
        ((domena) ? "; domain=" + domena : "") +
        ((bezpieczne) ? "; secure" : "");
}

// usunicie cookie poprzez ustawienie daty wyganicia w przeszoci
function usunCookie(nazwa, sciezka, domena) {
    if (pobierzCookie(nazwa)) {
        document.cookie = nazwa + "=" +
            ((sciezka) ? "; path=" + sciezka : "") +
            ((domena) ? "; domain=" + domena : "") +
            "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    }
}

