// Odczytuje nazwe, identyfikator, typ i warto jednego elementu
// sterujcego formularza, na danie funkcji formularzNaTabliceLancuchow()
function obiektFormularzaNaLacuch(obiekt) {
    var wyniki = "{";
    if (obiekt.name) {
        wyniki += "nazwa:'" + obiekt.name + "',";
    }
    if (obiekt.id) {
        wyniki += "id:'" + obiekt.id + "',";
    }
    wyniki += "typ:'" + obiekt.type + "',";
    switch (obiekt.type) {
        case "radio":
            if (obiekt.name) {
                obiekt = document.forms[0].elements[obiekt.name];
                var wartRadio = "wartosc:false,indeks:-1";
                for (var i = 0; i < obiekt.length; i++) {
                    if (obiekt[i].checked) {
                        wartRadio = "wartosc:true,indeks:" + i;
                        i = obiekt.length;
                    } 
                }
                wyniki += wartRadio;
            } else {
                wyniki += "wartosc:" + obiekt.checked;
            }
            break;
        case "checkbox":
            wyniki += "wartosc:" + obiekt.checked;
            break;
        case "select-one":
            wyniki += "wartosc:" + obiekt.selectedIndex;
            break;
        case "select-multiple":
            wyniki += "wartosc:" + obiekt.selectedIndex;
            break;
        case "text":
            wyniki += "wartosc:'" + escape(obiekt.value) + "'";
            break;
        case "textarea":
            wyniki += "wartosc:'" + escape(obiekt.value) + "'";
            break;
        case "password":
            wyniki += "wartosc:'" + escape(obiekt.value) + "'";
            break;
        case "hidden":
            wyniki += "wartosc:'" + escape(obiekt.value) + "'";
            break;
        default:
            wyniki += "";
    }
    wyniki += "}"
    return wyniki;
}

// Konwertuje przekazany formularz na acuch znakw sformatowany
// jako tablica obiektw JavaScriptu
function formularzNaTabliceLancuchow(formularz) {
    var element, ostatniaNazwa = "";
    var wyniki = "[";
    for (var i = 0; i < formularz.elements.length; i++) {
        element = formularz.elements[i];
        if (element.name && (element.name != ostatniaNazwa)) {
            wyniki += obiektFormularzaNaLacuch(formularz.elements[i]) + ",";
            ostatniaNazwa = element.name;
        }
    }
    wyniki = wyniki.substring(0, wyniki.length-1) + "]";
    return wyniki;
}

// Zapisuje wartoci elementw sterujcych innego formularza w formularzu
// na danej stronie, nazwy lub identyfikatory elementw na biecej stronie
// musz odpowiada tym w elementach oryginych
function lancuchNaFormularz(formularz, lancuch) {
    var element, tablicaObiektow = eval(lancuch);
    for (var i = 0; i < tablicaObiektow.length; i++) {
        element = (tablicaObiektow[i].nazwa) ? formularz.elements[tablicaObiektow[i].nazwa] 
                                    : document.getElementById(tablicaObiektow[i].id);
        switch (tablicaObiektow[i].typ) {
            case "radio":
                if (tablicaObiektow[i].nazwa && tablicaObiektow[i].wartosc && tablicaObiektow[i].indeks >= 0) {
                    element = element[tablicaObiektow[i].indeks];
                }
                element.checked = tablicaObiektow[i].wartosc;
                break;
            case "checkbox":
                element.checked = tablicaObiektow[i].wartosc;
                break;
            case "select-one":
                element.selectedIndex = tablicaObiektow[i].wartosc;
                break;
            case "select-multiple":
                element.selectedIndex = tablicaObiektow[i].wartosc;
                break;
            default:
                element.value = unescape(tablicaObiektow[i].wartosc);
        }
    }
}
