/****************************************************
base64.js
---------
Biblioteka JavaScripta do kodowania i dekodowania w Base64 
Autor: Danny Goodman (http://www.dannyg.com).

Opisana w ksice "JavaScript i DHTML. Receptury" 
wydanej przez wydawnictwo Helion. Copyright 2003.

[Wzorowana na wielu przykadach napisanych w wielu jzykach 
programowania, lecz gwnie na procedurach napisanych w Javie,
ktre znalazem w internetowym kursie Hamisha Taylora pod adresem
   http://www.cee.hw.ac.uk/courses/2nq3/4/
Bardzo pomocne byy operacje na danych binarnych.]

Po doczeniu do dokumentu HTML i wywietleniu go w przegldarce
obsugujcej skrypty, biblioteka inicjuje si sama.
Jej dziaanie zostao sprawdzone w przegldarkach zaczynajc od 
Netscape 4 roaz Internet Explorer 5 (Windows i Mac).

Dwie funkcje "publiczne" akceputuj jeden argument - 
acuch znakw ktry naley zakodowa lub odkodowa 
i zwracaj acuch znakw (zakodowany lub odkodowany).
Poniewa biblioteka ta zostaa zaprojektowana w celu 
wykorzystania po stronie klienta (czyli, adne zakodowane dane
nie maj by przesyane na serwer, przedstawione tu funkcje 
ignoruj limit 76 znakw dugoci wiersza, jakiemu podlegaj
transmisje MIME. Szczegowe informacje na temat kodowania 
mona znale na stronie

http://www.ietf.org/rfc/rfc2045.txt

Te funkcje s uywane do kodowania/dekodowania wartoci 
atrybutw elementw HTML, ktre nie mog zawiera znaku "="
dlatego nie pozwalamy na dopenianie blokw o dugoci 
nieparzystej.

Aby zakodowa acuch znaley wywoa:

 var lancuchZakodowany = kodujWBase64("acuchDoZakodowania");
 
Aby odkodowa naley wywoa:

 var zwyklyTekst = dekodujZBase64("lancuchZakodowany");

Historia wersji
---------------
v.1.00    07Apr2003    Wersja pierwsza

****************************************************/
// Globalne tablice do konwersji base64 
var enc64List, dec64List;

// Jednokrotna inicjalizacja tablic
function inicjujBase64() {
    enc64List = new Array();
    dec64List = new Array();
    var i;
    for (i = 0; i < 26; i++) {
        enc64List[enc64List.length] = String.fromCharCode(65 + i);
    }
    for (i = 0; i < 26; i++) {
        enc64List[enc64List.length] = String.fromCharCode(97 + i);
    }
    for (i = 0; i < 10; i++) {
        enc64List[enc64List.length] = String.fromCharCode(48 + i);
    }
    enc64List[enc64List.length] = "+";
    enc64List[enc64List.length] = "/";
    for (i = 0; i < 128; i++) {
        dec64List[dec64List.length] = -1;
    }
    for (i = 0; i < 64; i++) {
        dec64List[enc64List[i].charCodeAt(0)] = i;
    }
}

function kodujWBase64(str) {
    var c, d, e, end = 0;
    var u, v, w, x;
    var ptr = -1;
    var wejscie = str.split("");
    var wyjscie = "";
    while(end == 0) {
        c = (typeof wejscie[++ptr] != "undefined") ? wejscie[ptr].charCodeAt(0) : 
            ((end = 1) ? 0 : 0);
        d = (typeof wejscie[++ptr] != "undefined") ? wejscie[ptr].charCodeAt(0) : 
            ((end += 1) ? 0 : 0);
        e = (typeof wejscie[++ptr] != "undefined") ? wejscie[ptr].charCodeAt(0) : 
            ((end += 1) ? 0 : 0);
        u = enc64List[c >> 2];
        v = enc64List[(0x00000003 & c) << 4 | d >> 4];
        w = enc64List[(0x0000000F & d) << 2 | e >> 6];
        x = enc64List[e & 0x0000003F];
        
        // obsuga dopenienia w celu uzupenienia acuchw o nieparzystej
        // dugoci
        if (end >= 1) {x = "=";}
        if (end == 2) {w = "=";}
        
        if (end < 3) {wyjscie += u + v + w + x;}
    }
    // format dla wierszy o dugoci 76 znakw 
    var sformatowaneWyjscie = "";
    var lineLength = 76;
    while (wyjscie.length > lineLength) {
    	sformatowaneWyjscie += wyjscie.substring(0, lineLength) + "\n";
    	wyjscie = wyjscie.substring(lineLength);
    }
    sformatowaneWyjscie += wyjscie;
    return sformatowaneWyjscie;
}

function dekodujZBase64(str) {
    var c=0, d=0, e=0, f=0, i=0, n=0;
    var wejscie = str.split("");
    var wyjscie = "";
    var ptr = 0;
    do {
        f = wejscie[ptr++].charCodeAt(0);
        i = dec64List[f];
        if ( f >= 0 && f < 128 && i != -1 ) {
            if ( n % 4 == 0 ) {
                c = i << 2;
            } else if ( n % 4 == 1 ) {
                c = c | ( i >> 4 );
                d = ( i & 0x0000000F ) << 4;
            } else if ( n % 4 == 2 ) {
                d = d | ( i >> 2 );
                e = ( i & 0x00000003 ) << 6;
            } else {
                e = e | i;
            }
            n++;
            if ( n % 4 == 0 ) {
                wyjscie += String.fromCharCode(c) + 
                           String.fromCharCode(d) + 
                           String.fromCharCode(e);
            }
        }
    }
    while (typeof wejscie[ptr] != "undefined");
    wyjscie += (n % 4 == 3) ? String.fromCharCode(c) + String.fromCharCode(d) : 
               ((n % 4 == 2) ? String.fromCharCode(c) : "");
    return wyjscie;
}

// Automatyczna inicjalizacja globalnych tablic konwersji
inicjujBase64();
