r10 SVM
================

Przykład ze spiralami pochodzi z:

> K. J. Lang and M. J. Witbrock, “Learning to tell two spirals apart.”
> In Proceedings of the 1988 Connectionist Models Summer School, D.
> Touretzky, G. Hinton, and T. Sejnowski (eds), Morgan Kaufmann, 1988
> (pp. 52-59).

Rozwiązania zostały opisane w rozdziale 10. książki [*Praktyczna analiza
danych z R. Wydanie 2.*, Zumel, Mount; Helion
2021](http://www.practicaldatascience.com).

00433\_przyklad\_10.22\_z\_podpunktu\_10.3.1.R

``` r
# przykład 10.22 z podpunktu 10.3.1 
# (przykład 10.22 z podpunktu 10.3.1)  : Zaawansowane metody uczenia maszynowego : Rozwiązywanie problemów „nierozdzielnych” za pomocą maszyn wektorów nośnych : Używanie maszyn SVM do rozwiązywania problemów 
# Tytuł: Przygotowywanie danych spiralnych jako problemu klasyfikacji 

library('kernlab')
```

    ## Warning: package 'kernlab' was built under R version 4.0.3

``` r
data('spirals')     # Uwaga 1. 
sc <- specc(spirals, centers = 2)   # Uwaga 2. 
s <- data.frame(x=spirals[,1],y=spirals[,2],
   class=as.factor(sc))     # Uwaga 3. 

library('ggplot2')
```

    ## 
    ## Attaching package: 'ggplot2'

    ## The following object is masked from 'package:kernlab':
    ## 
    ##     alpha

``` r
ggplot(data=s) +
  geom_text(aes(x = x, y = y,
                label = class, color = class)) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position  ='none') +
  ggtitle("Przykładowe zadanie: oddzielanie jedynek od dwójek")
```

![](r10_SVM_files/figure-gfm/00433_przyklad_10.22_z_podpunktu_10.3.1.R-1.png)<!-- -->

``` r
# Uwaga 1. 
#   Wczytuje jądro kernlab i pakiet z maszynami SVM, po czym generuje dane spiralne. 

# Uwaga 2. 
#   Wykorzystuje procedurę widmowej analizy skupień do wyznaczenia dwóch różnych spiral w przykładowym zestawie danych. 

# Uwaga 3. 
#   Łączy współrzędne spiral i etykiety w ramce danych.  

# Uwaga 4. 
#   Tworzy wykres danych spiralnych wraz z etykietami klas. 
```

00434\_przyklad\_10.23\_z\_podpunktu\_10.3.1.R

``` r
# przykład 10.23 z podpunktu 10.3.1 
# (przykład 10.23 z podpunktu 10.3.1)  : Zaawansowane metody uczenia maszynowego : Rozwiązywanie problemów „nierozdzielnych” za pomocą maszyn wektorów nośnych : Używanie maszyn SVM do rozwiązywania problemów 
# Tytuł: Maszyna SVM z niewłaściwie dobranym jądrem 

set.seed(2335246L)
s$group <- sample.int(100, size = dim(s)[[1]], replace = TRUE)
sTrain <- subset(s, group > 10)
sTest <- subset(s,group <= 10)  # Uwaga 1. 

library('e1071')
```

    ## Warning: package 'e1071' was built under R version 4.0.3

``` r
mSVMV <- svm(class~x+y,data=sTrain,kernel='linear',type='nu-classification')    # Uwaga 2. 
sTest$predSVMV <- predict(mSVMV,newdata=sTest,type='response')  # Uwaga 3. 

shading <- expand.grid(
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predSVMV <- predict(mSVMV, newdata = shading, type = 'response')

ggplot(mapping = aes(x = x, y = y)) +
  geom_tile(data = shading, aes(fill = predSVMV),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predSVMV), 
            size=12) +
  geom_text(data = s,aes(label = class, color = class),
            alpha=0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position='none') +
  ggtitle("Jądro liniowe")
```

![](r10_SVM_files/figure-gfm/00434_przyklad_10.23_z_podpunktu_10.3.1.R-1.png)<!-- -->

``` r
# Uwaga 1. 
#   Przygotowanie do próby określenia etykiet klas w danych spiralnych ze współrzędnych za pomocą maszyny SVM. 

# Uwaga 2.
#   Tworzy model wektorów nośnych za pomocą jądra vanilladot (niezbyt dobrego jądra). 

# Uwaga 3. 
#   Wykorzystuje model do przewidywania klas na danych odłożonych. 

# Uwaga 4. 
#   Tworzy wykres przewidywań nałożonych na kopie wszystkich danych, dzięki czemu możemy przekonać się, czy predykcje zgadzają się z pierwotnymi etykietami. 
```

00435\_przyklad\_10.24\_z\_podpunktu\_10.3.1.R

``` r
# przykład 10.24 z podpunktu 10.3.1 
# (przykład 10.24 z podpunktu 10.3.1)  : Zaawansowane metody uczenia maszynowego : Rozwiązywanie problemów „nierozdzielnych” za pomocą maszyn wektorów nośnych : Używanie maszyn SVM do rozwiązywania problemów 
# Tytuł: Maszyna SVM z właściwie dobranym jądrem 

mSVMG <- svm(class~x+y,data=sTrain,kernel='radial',type='nu-classification')    # Uwaga 1. 
sTest$predSVMG <- predict(mSVMG,newdata=sTest,type='response')

shading <- expand.grid(
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predSVMG <- predict(mSVMG, newdata = shading, type = 'response')

ggplot(mapping = aes(x = x, y = y)) +
  geom_tile(data = shading, aes(fill = predSVMG),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predSVMG), 
            size=12) +
  geom_text(data = s,aes(label = class, color = class),
            alpha=0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position='none') +
  ggtitle("Jądro radialne/gaussowskie")
```

![](r10_SVM_files/figure-gfm/00435_przyklad_10.24_z_podpunktu_10.3.1.R-1.png)<!-- -->

``` r
# Uwaga 1. 
#   Tym razem wykorzystuje jądro radialne (gaussowskie), będące przydatnym wskaźnikiem odległości geometrycznej.  
```

``` r
mSVMG <- svm(class~x+y,data=sTrain,kernel='radial',type='nu-classification',
                          nu = 0.05) 

sTest$predSVMG <- predict(mSVMG,newdata=sTest,type='response')

shading <- expand.grid(
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predSVMG <- predict(mSVMG, newdata = shading, type = 'response')

ggplot(mapping = aes(x = x, y = y)) +
  geom_tile(data = shading, aes(fill = predSVMG),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predSVMG), 
            size=12) +
  geom_text(data = s,aes(label = class, color = class),
            alpha=0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position='none') +
  ggtitle("Jądro radialne/gausswoskie z małym nu")
```

![](r10_SVM_files/figure-gfm/small_nu-1.png)<!-- -->

``` r
mSVMG <- svm(class~x+y,data=sTrain,kernel='radial',type='nu-classification',
                          nu = 0.8)

sTest$predSVMG <- predict(mSVMG,newdata=sTest,type='response')

shading <- expand.grid(
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predSVMG <- predict(mSVMG, newdata = shading, type = 'response')

ggplot(mapping = aes(x = x, y = y)) +
  geom_tile(data = shading, aes(fill = predSVMG),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predSVMG), 
            size=12) +
  geom_text(data = s,aes(label = class, color = class),
            alpha=0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position='none') +
  ggtitle("Jądro radialne/gausswoskie z dużym nu")
```

![](r10_SVM_files/figure-gfm/large_nu-1.png)<!-- -->

Próba z użyciem biblioteki `xgboost`.

Działająca wersja ćwiczenia opisanego w rozdziale 10. książki
[*Praktyczna analiza danych z R. Wydanie 2.*, Zumel, Mount; Helion
2021](http://www.practicaldatascience.com).

``` r
library("xgboost")
```

    ## Warning: package 'xgboost' was built under R version 4.0.3

``` r
sTrain$xg_class <- ifelse(sTrain$class=="2", TRUE, FALSE)
mxgb <- xgboost(as.matrix(sTrain[, c("x", "y")]), 
                label = sTrain$xg_class,
                params=list(
                  objective="binary:logistic"
                ),
                nrounds = 100,
                verbose = FALSE)
sTest$predxgb <- predict(mxgb, newdata = as.matrix(sTest[, c("x", "y")]))
sTest$predxgb <- ifelse(sTest$predxgb>0.5, "2", "1")

shading <- expand.grid(
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predxgb <- predict(mxgb, newdata = as.matrix(shading))
shading$predxgb <- shading$predxgb > 0.5

ggplot(mapping = aes(x = x, y = y)) +
  geom_tile(data = shading, aes(fill = predxgb),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predxgb), 
            size=12) +
  geom_text(data = s,aes(label = class, color = class),
            alpha=0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position='none') +
  ggtitle("Spirale xgboost")
```

![](r10_SVM_files/figure-gfm/xgboost-1.png)<!-- -->
