# przykad B.20 z punktu B.3.1 
# (przykad B.20 z punktu B.3.1)  : Wane pojcia z dziedziny statystyki : Przykady spojrzenia na dane z perspektywy statystyki : Bd systematyczny prby 
# Tytu: Tworzenie obcionego widoku dochodw i zyskw kapitaowych 

library(ggplot2)
ggplot(data=d,aes(x=EarnedIncome,y=CapitalGains)) +
  geom_point() + geom_smooth(method='lm') +
  coord_cartesian(xlim=c(0,max(d)),ylim=c(0,max(d)))                   	# Uwaga 1. 
ggplot(data=veryHighIncome,aes(x=EarnedIncome,y=CapitalGains)) +
  geom_point() + geom_smooth(method='lm') +
  geom_point(data=subset(d,EarnedIncome+CapitalGains<500000),
             aes(x=EarnedIncome,y=CapitalGains),
             shape=4,alpha=0.5,color='red') +
  geom_segment(x=0,xend=500000,y=500000,yend=0,
               linetype=2,alpha=0.5,color='red') +
  coord_cartesian(xlim=c(0,max(d)),ylim=c(0,max(d)))                   	# Uwaga 2. 
print(with(subset(d,EarnedIncome+CapitalGains<500000),
           cor.test(EarnedIncome,CapitalGains,method='spearman')))              	# Uwaga 3. 
#
#        Spearman's rank correlation rho
#
#data:  EarnedIncome and CapitalGains
#S = 107664, p-value = 0.6357
#alternative hypothesis: true rho is not equal to 0
#sample estimates:
#        rho
#-0.05202267

# Uwaga 1. 
#   Tworzy wykres wszystkich danych dochodw z prost trendu liniowego (i tam niepewnoci). 

# Uwaga 2. 
#   Tworzy wykres danych osb o duych dochodach i prost trendu liniowego (a take lini odcicia i odcite dane). 

# Uwaga 3. 
#   Oblicza korelacj pomidzy odcitymi danymi. 

