# przykad B.10 z punktu B.1.4 
# (przykad B.10 z punktu B.1.4)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad dwumianowy 
# Tytu: Praca z rozkadem dwumianowym 

# przykad uycia funkcji pbinom

nflips <- 100
nheads <- c(25, 45, 50, 60)  # liczba reszek

# jakie s maksymalne prawdopodobiestwa zaobserwowania 
# takiej liczby reszek w rzutach zwyk monet?
left.tail <- pbinom(nheads, nflips, 0.5)
sprintf("%2.2f", left.tail)
# [1] "0.00" "0.18" "0.54" "0.98"

# prawdopodobiestwa zaobserwowania wikszej liczby reszek
# w czasie rzutw zwyk monet?
right.tail <- pbinom(nheads, nflips, 0.5, lower.tail = FALSE)
sprintf("%2.2f", right.tail)
# [1] "1.00" "0.82" "0.46" "0.02"

# zgodnie z przewidywaniami:
left.tail+right.tail
#  [1] 1 1 1 1 

# zatem jeli rzucisz 100 razy zwyk monet,
# z pewnoci wylosujesz ponad 10 reszek, 
# prawie na pewno zaobserwujesz mniej ni 60 reszek,
# ale prawdopodobnie wicej ni 45.

# przykad uycia funkcji qbinom

nflips <- 100

# jaki jest 95-procentowy "rodkowy" przedzia reszek, jaki mona 
# zaobserwowa po 100 rzutach zwyk monet?

left.edge <- qbinom(0.025, nflips, 0.5)
right.edge <- qbinom(0.025, nflips, 0.5, lower.tail = FALSE)
c(left.edge, right.edge)
# [1] 40 60

# zatem istnieje 95% prawdopodobiestwa, e zaobserwujesz od 40 do 60 reszek

