# przykad 10.17 z punktu 10.2.4 
# (przykad 10.17 z punktu 10.2.4)  : Zaawansowane metody uczenia maszynowego : Wykrywanie relacji niemonotonicznych za pomoc uoglnionych modeli addytywnych : Stosowanie modelu GAM na rzeczywistych danych 
# Tytu: Stosowanie regresji liniowej (bez uycia modelu GAM i z jego uyciem) na zestawie danych 2010 Natality 

library(mgcv)
library(ggplot2)
load("CDC/NatalBirthData.rData")
train <- sdata[sdata$ORIGRANDGROUP <= 5, ]
test <- sdata[sdata$ORIGRANDGROUP > 5, ]

form_lin <- as.formula("DBWT ~ PWGT + WTGAIN + MAGER + UPREVIS")
linmodel <- lm(form_lin, data = train)                                	# Uwaga 1.  
summary(linmodel)

## Call:
## lm(formula = form_lin, data = train)
## 
## Residuals:
##      Min       1Q   Median       3Q      Max 
## -3155.43  -272.09    45.04   349.81  2870.55 
## 
## Coefficients:
##              Estimate Std. Error t value Pr(>|t|)    
## (Intercept) 2419.7090    31.9291  75.784  < 2e-16 ***
## PWGT           2.1713     0.1241  17.494  < 2e-16 ***
## WTGAIN         7.5773     0.3178  23.840  < 2e-16 ***
## MAGER          5.3213     0.7787   6.834  8.6e-12 ***
## UPREVIS       12.8753     1.1786  10.924  < 2e-16 ***
## ---
## Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
## 
## Residual standard error: 562.7 on 14381 degrees of freedom
## Multiple R-squared:  0.06596,    Adjusted R-squared:  0.0657       	# Uwaga 2. 
## F-statistic: 253.9 on 4 and 14381 DF,  p-value: < 2.2e-16

form_gam <- as.formula("DBWT ~ s(PWGT) + s(WTGAIN) +
                        s(MAGER) + s(UPREVIS)")
gammodel <- gam(form_gam, data = train)                            	# Uwaga 3. 
gammodel$converged                                                	# Uwaga 4. 
## [1] TRUE

summary(gammodel)

## 
## Family: gaussian 
## Link function: identity 
## 
## Formula:
## DBWT ~ s(PWGT) + s(WTGAIN) + s(MAGER) + s(UPREVIS)
## 
## Parametric coefficients:
##             Estimate Std. Error t value Pr(>|t|)    
## (Intercept) 3276.948      4.623   708.8   <2e-16 ***
## ---
## Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
## 
## Approximate significance of smooth terms:
##              edf Ref.df       F  p-value    
## s(PWGT)    5.374  6.443  69.010  < 2e-16 ***
## s(WTGAIN)  4.719  5.743 102.313  < 2e-16 ***
## s(MAGER)   7.742  8.428   7.145 1.37e-09 ***
## s(UPREVIS) 5.491  6.425  48.423  < 2e-16 ***
## ---
## Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
## 
## R-sq.(adj) =  0.0927   Deviance explained = 9.42%                  	# Uwaga 5. 
## GCV = 3.0804e+05  Scale est. = 3.0752e+05  n = 14386

# Uwaga 1: 
#   Tworzy model liniowy wykorzystujcy cztery zmienne. 

# Uwaga 2: 
#   Model wyjania ok. 6,6% wariancji; wszystkie wspczynniki rni si znacznie od 0. 

# Uwaga 3: 
#   Tworzy model GAM wykorzystujcy te same zmienne. 

# Uwaga 4: 
#   Sprawdza, czy model uzyska zbieno.

# Uwaga 5: 
#   Model wyjania nieco ponad 9% wariancji; wszystkie zmienne cechuj si nieliniowoci znacznie odbiegajc od 0.

