# nieoficjalny przykad A.7 z punktu A.3.1 
# (nieoficjalny przykad A.7 z punktu A.3.1)  : Korzystanie z R i innych narzdzi : Stosowanie baz danych wraz z R : Realizowanie kwerend bazodanowych za pomoc generatora kwerend 

ops <- data_handle %.>%                      	# Uwaga 1. 
  extend(.,                                    	# Uwaga 2. 
         prosta_ocena = rank(),
         partitionby = "nazwa_uzytkownika",
         orderby = "przewidywane_powinowactwo_ofert",
         reverse = "przewidywane_powinowactwo_ofert") %.>%
  select_rows(.,                               	# Uwaga 3. 
              prosta_ocena <= 2) %.>%
  orderby(., c("nazwa_uzytkownika", "prosta_ocena"))      	# Uwaga 4. 

result_table <- materialize(db, ops)                      	# Uwaga 5. 

DBI::dbReadTable(db$connection, result_table$table_name) %.>%     	# Uwaga 6. 
  knitr::kable(.)

#| nazwa_uzytkownika  | produkt                             |  rabat   |  przewidywane_powinowactwo_ofert  |  prosta_ocena |
#|:-------------------|:------------------------------------|---------:|----------------------------------:|--------------:|
#| John               | Gra planszowa Pandemia              |      0.10|                            0.85960|              1|
#| John               | Pioro wieczne Pelikan M200          |      0.20|                            0.67060|              2|
#| Nina               | Pioro wieczne Pelikan M200          |      0.10|                            0.61600|              1|
#| Nina               | Laptop Dell XPS                     |      0.05|                            0.31790|              2|

# Uwaga 1. 
#   Definiuje nasz sekwencj operacji. 

# Uwaga 2. 
#   Oznacza kady rzd za pomoc prostej rangi definiowanej dla kadego uytkownika. 

# Uwaga 3. 
#   Wybiera dla kadego uytkownika dwa rzdy o najwikszej randze. 

# Uwaga 4. 
#   Okrela kolejno rzdw ze wzgldu na uytkownika i rang produktu. 

# Uwaga 5.
#   Realizuje rezultat w bazie danych i tworzy now tabel wynikow. 

# Uwaga 6. 
#   Kopiuje wynik do R i wywietla go w czytelny sposb. 

